/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import ca.odell.glazedlists.gui.TableFormat;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.table.TableColumn;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;

public class ConnectionTableFormat
implements TableFormat<ConnectionItem> {
    private static final String CONNECTING_STRING = I18n.tr("Connecting...");
    private static final String OUTGOING_STRING = I18n.tr("Outgoing");
    private static final String INCOMING_STRING = I18n.tr("Incoming");
    private static final String CONNECTED_ON = I18n.tr("Connected on");
    private static final String LEAF = I18n.tr("Leaf");
    private static final String ULTRAPEER = I18n.tr("Ultrapeer");
    private static final String PEER = I18n.tr("Peer");
    private static final String STANDARD = I18n.tr("Standard");
    public static final int HOST_IDX = 0;
    public static final int STATUS_IDX = 1;
    public static final int MESSAGES_IDX = 2;
    public static final int MESSAGES_IN_IDX = 3;
    public static final int MESSAGES_OUT_IDX = 4;
    public static final int BANDWIDTH_IDX = 5;
    public static final int BANDWIDTH_IN_IDX = 6;
    public static final int BANDWIDTH_OUT_IDX = 7;
    public static final int DROPPED_IDX = 8;
    public static final int DROPPED_IN_IDX = 9;
    public static final int DROPPED_OUT_IDX = 10;
    public static final int PROTOCOL_IDX = 11;
    public static final int VENDOR_IDX = 12;
    public static final int TIME_IDX = 13;
    public static final int COMPRESSION_IDX = 14;
    public static final int COMPRESSION_IN_IDX = 15;
    public static final int COMPRESSION_OUT_IDX = 16;
    public static final int SSL_IDX = 17;
    public static final int SSL_IN_IDX = 18;
    public static final int SSL_OUT_IDX = 19;
    public static final int QRP_FULL_IDX = 20;
    public static final int QRP_USED_IDX = 21;
    private final ConnectionColumn[] columns = new ConnectionColumn[]{new ConnectionColumn(0, "CV_COLUMN_HOST", I18n.tr("Host"), 218, true, String.class), new ConnectionColumn(1, "CV_COLUMN_STATUS", I18n.tr("Status"), 70, true, String.class), new ConnectionColumn(2, "CV_COLUMN_MESSAGE", I18n.tr("Messages (I/O)"), 97, true, MessagesValue.class), new ConnectionColumn(3, "CV_COLUMN_MESSAGE_IN", I18n.tr("Messages In"), 97, false, Integer.class), new ConnectionColumn(4, "CV_COLUMN_MESSAGE_OUT", I18n.tr("Messages Out"), 97, false, Integer.class), new ConnectionColumn(5, "CV_COLUMN_BANDWIDTH", I18n.tr("Bandwidth (I/O)"), 115, true, BandwidthValue.class), new ConnectionColumn(6, "CV_COLUMN_BANDWIDTH_IN", I18n.tr("Bandwidth In"), 115, false, BandwidthValue.class), new ConnectionColumn(7, "CV_COLUMN_BANDWIDTH_OUT", I18n.tr("Bandwidth Out"), 115, false, BandwidthValue.class), new ConnectionColumn(8, "CV_COLUMN_DROPPED", I18n.tr("Dropped (I/O)"), 92, true, DroppedValue.class), new ConnectionColumn(9, "CV_COLUMN_DROPPED_IN", I18n.tr("Dropped In"), 92, false, DroppedValue.class), new ConnectionColumn(10, "CV_COLUMN_DROPPED_OUT", I18n.tr("Dropped Out"), 92, false, DroppedValue.class), new ConnectionColumn(11, "CV_COLUMN_PROTOCOL", I18n.tr("Protocol"), 60, true, ProtocolValue.class), new ConnectionColumn(12, "CV_COLUMN_VENDOR", I18n.tr("Vendor/Version"), 116, true, String.class), new ConnectionColumn(13, "CV_COLUMN_TIME", I18n.tr("Time"), 44, true, TimeRemainingValue.class), new ConnectionColumn(14, "CV_COLUMN_COMPRESSION", I18n.tr("Compressed (I/O)"), 114, false, DroppedValue.class), new ConnectionColumn(15, "CV_COLUMN_COMPRESSION_IN", I18n.tr("Compressed In"), 114, false, DroppedValue.class), new ConnectionColumn(16, "CV_COLUMN_COMPRESSION_OUT", I18n.tr("Compressed Out"), 114, false, DroppedValue.class), new ConnectionColumn(17, "CV_COLUMN_SSL", I18n.tr("SSL Overhead (I/O)"), 100, false, DroppedValue.class), new ConnectionColumn(18, "CV_COLUMN_SSL_IN", I18n.tr("SSL Overhead In"), 100, false, DroppedValue.class), new ConnectionColumn(19, "CV_COLUMN_SSL_OUT", I18n.tr("SSL Overhead Out"), 100, false, DroppedValue.class), new ConnectionColumn(20, "CV_COLUMN_QRP_FULL", I18n.tr("QRP (%)"), 70, false, QRPValue.class), new ConnectionColumn(21, "CV_COLUMN_QRP_USED", I18n.tr("QRP Empty"), 70, false, String.class)};

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int column) {
        if (column < this.columns.length) {
            return this.columns[column].getName();
        }
        return null;
    }

    @Override
    public Object getColumnValue(ConnectionItem baseObject, int column) {
        if (column < this.columns.length) {
            return this.getValueAt(baseObject, column);
        }
        return null;
    }

    public ConnectionColumn getColumn(int index) {
        return this.columns[index];
    }

    private String getStatusText(ConnectionItem connectionItem) {
        switch (connectionItem.getStatus()) {
            case OUTGOING: {
                return OUTGOING_STRING;
            }
            case INCOMING: {
                return INCOMING_STRING;
            }
        }
        return CONNECTING_STRING;
    }

    public String[] getToolTipArray(ConnectionItem connectionItem) {
        Properties props = connectionItem.getHeaderProperties();
        ArrayList<String> tips = new ArrayList<String>();
        if (props == null) {
            tips.add(CONNECTED_ON + " " + GuiUtils.msec2DateTime(connectionItem.getTime()));
        } else {
            tips.add(CONNECTED_ON + " " + GuiUtils.msec2DateTime(connectionItem.getTime()));
            tips.add("");
            Enumeration<?> ps = props.propertyNames();
            while (ps.hasMoreElements()) {
                String k = (String)ps.nextElement();
                tips.add(k + ": " + props.getProperty(k));
            }
        }
        return tips.toArray(new String[tips.size()]);
    }

    private Object getValueAt(ConnectionItem connectionItem, int index) {
        switch (index) {
            case 0: {
                if (!connectionItem.isAddressResolved() && connectionItem.isConnected() && System.currentTimeMillis() - connectionItem.getTime() > 10000L && SwingUiSettings.RESOLVE_CONNECTION_HOSTNAMES.getValue()) {
                    this.assignHostName(connectionItem);
                } else if (connectionItem.isAddressResolved() && !SwingUiSettings.RESOLVE_CONNECTION_HOSTNAMES.getValue()) {
                    connectionItem.resetHostName();
                }
                return connectionItem.getHostName() + ":" + connectionItem.getPort();
            }
            case 1: {
                return this.getStatusText(connectionItem);
            }
            case 2: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new MessagesValue(connectionItem.getNumMessagesReceived(), connectionItem.getNumMessagesSent());
            }
            case 3: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return connectionItem.getNumMessagesReceived();
            }
            case 4: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return connectionItem.getNumMessagesSent();
            }
            case 5: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new BandwidthValue(connectionItem.getMeasuredDownstreamBandwidth(), connectionItem.getMeasuredUpstreamBandwidth());
            }
            case 6: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new BandwidthValue(connectionItem.getMeasuredDownstreamBandwidth());
            }
            case 7: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new BandwidthValue(connectionItem.getMeasuredUpstreamBandwidth());
            }
            case 8: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue((float)connectionItem.getNumReceivedMessagesDropped() / ((float)connectionItem.getNumMessagesReceived() + 1.0f), (float)connectionItem.getNumSentMessagesDropped() / ((float)connectionItem.getNumMessagesSent() + 1.0f));
            }
            case 9: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue((float)connectionItem.getNumReceivedMessagesDropped() / ((float)connectionItem.getNumMessagesReceived() + 1.0f));
            }
            case 10: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue((float)connectionItem.getNumSentMessagesDropped() / ((float)connectionItem.getNumMessagesSent() + 1.0f));
            }
            case 11: {
                return new ProtocolValue(connectionItem);
            }
            case 12: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                String vendor = connectionItem.getUserAgent();
                return vendor == null ? "" : vendor;
            }
            case 13: {
                return new TimeRemainingValue((int)((System.currentTimeMillis() - connectionItem.getTime()) / 1000L));
            }
            case 14: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue(connectionItem.getReadSavedFromCompression(), connectionItem.getSentSavedFromCompression());
            }
            case 15: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue(connectionItem.getReadSavedFromCompression());
            }
            case 16: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new DroppedValue(connectionItem.getSentSavedFromCompression());
            }
            case 17: {
                return new DroppedValue(connectionItem.getReadLostFromSSL(), connectionItem.getSentLostFromSSL());
            }
            case 18: {
                return new DroppedValue(connectionItem.getReadLostFromSSL());
            }
            case 19: {
                return new DroppedValue(connectionItem.getSentLostFromSSL());
            }
            case 20: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                return new QRPValue(connectionItem.getQueryRouteTablePercentFull(), connectionItem.getQueryRouteTableSize());
            }
            case 21: {
                if (!connectionItem.isConnected()) {
                    return null;
                }
                int empty = connectionItem.getQueryRouteTableEmptyUnits();
                int inuse = connectionItem.getQueryRouteTableUnitsInUse();
                if (empty == -1 || inuse == -1) {
                    return null;
                }
                return empty + " / " + inuse;
            }
        }
        return null;
    }

    private void assignHostName(ConnectionItem connectionItem) {
        connectionItem.setAddressResolved(true);
        BackgroundExecutorService.execute(new HostAssigner(connectionItem));
    }

    private static class TimeRemainingValue
    implements Comparable<TimeRemainingValue> {
        private final int timeRemaining;

        public TimeRemainingValue(int intValue) {
            this.timeRemaining = intValue;
        }

        @Override
        public int compareTo(TimeRemainingValue o) {
            return o.timeRemaining - this.timeRemaining;
        }

        public String toString() {
            return this.timeRemaining == 0 ? "" : CommonUtils.seconds2time(this.timeRemaining);
        }
    }

    private static class QRPValue
    implements Comparable<QRPValue> {
        private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
        private final float percentFull;
        private final int size;
        private final String text;

        public QRPValue(double percentFull, int size) {
            this.percentFull = (float)percentFull;
            this.size = size;
            this.text = PERCENT_FORMAT.format(percentFull / 100.0) + " / " + GuiUtils.toKilobytes(size);
        }

        @Override
        public int compareTo(QRPValue other) {
            if (this.percentFull != other.percentFull) {
                return this.percentFull < other.percentFull ? -1 : 1;
            }
            if (this.size != other.size) {
                return this.size < other.size ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return this.text;
        }

        static {
            PERCENT_FORMAT.setMaximumFractionDigits(2);
            PERCENT_FORMAT.setMinimumFractionDigits(0);
            PERCENT_FORMAT.setGroupingUsed(false);
        }
    }

    private static class ProtocolValue
    implements Comparable<ProtocolValue> {
        private final int weight;
        private final String text;

        public ProtocolValue(ConnectionItem connectionItem) {
            this.weight = ProtocolValue.getWeightHostInfo(connectionItem);
            this.text = connectionItem.isLeaf() ? LEAF : (connectionItem.isUltrapeer() ? ULTRAPEER : (connectionItem.isPeer() ? PEER : STANDARD));
        }

        private static int getWeightHostInfo(ConnectionItem connectionItem) {
            if (connectionItem.isUltrapeerConnection()) {
                if (connectionItem.isUltrapeer()) {
                    return 1;
                }
                return 4;
            }
            if (connectionItem.isLeaf()) {
                return 2;
            }
            return 3;
        }

        @Override
        public int compareTo(ProtocolValue other) {
            return this.weight - other.weight;
        }

        public String toString() {
            return this.text;
        }
    }

    private static class MessagesValue
    implements Comparable<MessagesValue> {
        private final int received;
        private final int sent;
        private final String text;

        public MessagesValue(int received, int sent) {
            this.received = received;
            this.sent = sent;
            this.text = received + " / " + sent;
        }

        @Override
        public int compareTo(MessagesValue other) {
            return this.received + this.sent - (other.received + other.sent);
        }

        public String toString() {
            return this.text;
        }
    }

    private static class DroppedValue
    implements Comparable<DroppedValue> {
        private final int in;
        private final int out;
        private final String text;

        public DroppedValue(float in) {
            this.in = Math.min(100, (int)(in * 100.0f));
            this.out = 0;
            this.text = Integer.toString(this.in) + "%";
        }

        public DroppedValue(float in, float out) {
            this.in = Math.min(100, (int)(in * 100.0f));
            this.out = Math.min(100, (int)(out * 100.0f));
            this.text = Integer.toString(this.in) + "% / " + Integer.toString(this.out) + "%";
        }

        @Override
        public int compareTo(DroppedValue other) {
            return this.in + this.out - (other.in + other.out);
        }

        public String toString() {
            return this.text;
        }
    }

    private static class BandwidthValue
    implements Comparable<BandwidthValue> {
        private static final NumberFormat formatter = NumberFormat.getNumberInstance();
        private final float down;
        private final float up;
        private final String text;

        public BandwidthValue(float up) {
            this.up = up;
            this.down = 0.0f;
            this.text = I18n.tr(GuiUtils.KBPERSEC_FORMAT, formatter.format(up));
        }

        public BandwidthValue(float down, float up) {
            this.down = down;
            this.up = up;
            this.text = I18n.tr(GuiUtils.KBPERSEC_FORMAT, formatter.format(down) + " / " + formatter.format(up));
        }

        @Override
        public int compareTo(BandwidthValue other) {
            float me = this.down + this.up;
            float you = other.down + other.up;
            if (me > you) {
                return 1;
            }
            if (me < you) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.text;
        }

        static {
            formatter.setMinimumFractionDigits(3);
            formatter.setMaximumFractionDigits(3);
        }
    }

    private static class HostAssigner
    implements Runnable {
        private final WeakReference<ConnectionItem> item;

        HostAssigner(ConnectionItem connectionItem) {
            this.item = new WeakReference<ConnectionItem>(connectionItem);
        }

        @Override
        public void run() {
            ConnectionItem connectionItem = (ConnectionItem)this.item.get();
            if (connectionItem != null) {
                try {
                    connectionItem.setHostName(InetAddress.getByName(connectionItem.getHostName()).getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ConnectionColumn
    extends TableColumn {
        private final String id;
        private final String name;
        private final int width;
        private final boolean visible;
        private final Class<?> columnClass;

        public ConnectionColumn(int modelIndex, String id, String name, int width, boolean visible, Class<?> columnClass) {
            super(modelIndex);
            this.id = id;
            this.name = name;
            this.width = width;
            this.visible = visible;
            this.columnClass = columnClass;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public int getWidth() {
            return this.width;
        }
    }
}

