/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.animate;

import javax.swing.JWindow;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.animate.AbstractAnimator;
import org.limewire.ui.swing.animate.AnimatorEvent;
import org.limewire.ui.swing.util.WindowTransparencyUtils;

public class FadeInAnimator
extends AbstractAnimator<JWindow> {
    public FadeInAnimator(final JWindow window, int totalTime) {
        super(window, totalTime);
        this.addListener((EventListener)new EventListener<AnimatorEvent<JWindow>>(){

            @Override
            public void handleEvent(AnimatorEvent event) {
                if (event.getType() == AnimatorEvent.Type.STARTED) {
                    WindowTransparencyUtils.setAlpha(window, 0.0f);
                    window.setVisible(true);
                } else if (event.getType() == AnimatorEvent.Type.STEP) {
                    int currentStep = event.getAnimator().getCurrentStepNumber();
                    float alpha = (float)currentStep / (float)FadeInAnimator.this.getTotalNumberOfSteps();
                    WindowTransparencyUtils.setAlpha(window, alpha);
                } else if (event.getType() == AnimatorEvent.Type.STOPPED) {
                    WindowTransparencyUtils.setAlpha(window, 1.0f);
                }
            }
        });
    }
}

