/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.limewire.ui.swing.browser.BrowserUtils;
import org.limewire.util.OSUtils;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaKeyEvent;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebNavigation;

class MozillaKeyListener
extends KeyAdapter {
    private nsIWebNavigation nav;

    public MozillaKeyListener(final nsIWebBrowserChrome chrome) {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            @Override
            public void run() {
                MozillaKeyListener.this.nav = XPCOMUtils.qi(chrome.getWebBrowser(), nsIWebNavigation.class);
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e instanceof MozillaKeyEvent) {
            boolean backPressed;
            MozillaKeyEvent mozKeyEvent = (MozillaKeyEvent)e;
            boolean altDown = OSUtils.isMacOSX() ? mozKeyEvent.isMetaDown() : mozKeyEvent.isAltDown();
            boolean rightPressed = altDown && mozKeyEvent.getKeyCode() == 39;
            boolean leftPressed = altDown && mozKeyEvent.getKeyCode() == 37;
            boolean bl = backPressed = mozKeyEvent.getKeyCode() == 8 && !BrowserUtils.isTextControl(mozKeyEvent.getSourceNode());
            if (leftPressed || backPressed) {
                MozillaExecutor.mozAsyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MozillaKeyListener.this.nav.getCanGoBack()) {
                            MozillaKeyListener.this.nav.goBack();
                        }
                    }
                });
            } else if (rightPressed) {
                MozillaExecutor.mozAsyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MozillaKeyListener.this.nav.getCanGoForward()) {
                            MozillaKeyListener.this.nav.goForward();
                        }
                    }
                });
            } else if (mozKeyEvent.getKeyCode() == 116) {
                MozillaExecutor.mozAsyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MozillaKeyListener.this.nav.reload(0L);
                    }
                });
            }
        }
    }
}

