/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import org.limewire.ui.swing.browser.BrowserUtils;
import org.limewire.ui.swing.browser.MozillaKeyListener;
import org.limewire.ui.swing.components.LimeIconInfo;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.impl.ChromeAdapter;

public class MozillaPopupPanel
extends MozillaPanel {
    private final LimeIconInfo iconInfo = new LimeIconInfo();

    public MozillaPopupPanel(boolean attachNewBrowserOnCreation) {
        super(null, attachNewBrowserOnCreation, null, null);
        this.initialize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowIcon(this, this.iconInfo.getIconFile());
    }

    @Override
    public void setContainerWindow(IMozillaWindow parentWin) {
        super.setContainerWindow(parentWin);
        if (parentWin != null && parentWin instanceof JFrame) {
            JFrame frame = (JFrame)((Object)parentWin);
            if (!OSUtils.isMacOSX()) {
                frame.setIconImage(this.iconInfo.getImage());
            }
        }
    }

    private void initialize() {
        JToolBar toolbar = this.getToolbar();
        toolbar.add(new AbstractAction("Out"){

            @Override
            public void actionPerformed(ActionEvent e) {
                NativeLaunchUtils.openURL(MozillaPopupPanel.this.getUrl());
            }
        });
    }

    @Override
    public void onAttachBrowser(final ChromeAdapter chromeAdapter, ChromeAdapter parentChromeAdapter) {
        super.onAttachBrowser(chromeAdapter, parentChromeAdapter);
        BrowserUtils.addDomListener(chromeAdapter);
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                MozillaPopupPanel.this.addKeyListener(new MozillaKeyListener(chromeAdapter));
            }
        });
    }

    @Override
    public void onDetachBrowser() {
        if (this.getChromeAdapter() != null) {
            BrowserUtils.removeDomListener(this.getChromeAdapter());
        }
        super.onDetachBrowser();
    }
}

