/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.limewire.ui.swing.listener.ActionHandListener;
import org.limewire.ui.swing.listener.MouseActionListener;

public class ActionLabel
extends JLabel {
    private MouseListener urlListener;
    private PropertyChangeListener listener = null;
    private Action currentAction;
    private final List<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();

    public ActionLabel(Action action) {
        this(action, false);
    }

    public ActionLabel(Action action, boolean showHand) {
        this.setAction(action, showHand);
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(2);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void setAction(Action action, boolean showHand) {
        Action oldAction = this.getAction();
        if (oldAction != null) {
            oldAction.removePropertyChangeListener(this.getListener());
        }
        this.currentAction = action;
        this.currentAction.addPropertyChangeListener(this.getListener());
        if (showHand) {
            this.installListener(new ActionHandListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionLabel.this.currentAction.actionPerformed(e);
                    for (ActionListener listener : ActionLabel.this.actionListeners) {
                        listener.actionPerformed(e);
                    }
                }
            }));
        } else {
            this.installListener(new MouseActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionLabel.this.currentAction.actionPerformed(e);
                    for (ActionListener listener : ActionLabel.this.actionListeners) {
                        listener.actionPerformed(e);
                    }
                }
            }));
        }
        this.updateLabel(this.currentAction, null);
    }

    public Action getAction() {
        return this.currentAction;
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ActionLabel.this.updateLabel(null, evt);
                }
            };
        }
        return this.listener;
    }

    public void updateLabel(Action action, PropertyChangeEvent evt) {
        if (evt == null) {
            assert (action != null);
            String display = (String)this.currentAction.getValue("Name");
            this.setIcon((Icon)this.currentAction.getValue("SmallIcon"));
            this.setToolTipText((String)this.currentAction.getValue("ShortDescription"));
            this.setVisible(!Boolean.FALSE.equals(this.currentAction.getValue("limewire.visible")));
            if (display != null) {
                this.setText(display);
            }
        } else {
            assert (action == null);
            String id = evt.getPropertyName();
            if (id.equals("Name")) {
                this.setText((String)evt.getNewValue());
            } else if (id.equals("SmallIcon")) {
                this.setIcon((Icon)evt.getNewValue());
            } else if (id.equals("ShortDescription")) {
                this.setToolTipText((String)evt.getNewValue());
            } else if (id.equals("limewire.visible")) {
                this.setVisible(!Boolean.FALSE.equals(evt.getNewValue()));
            }
        }
    }

    private void installListener(MouseListener listener) {
        if (this.urlListener != null) {
            this.removeMouseListener(this.urlListener);
        }
        this.urlListener = listener;
        this.addMouseListener(this.urlListener);
    }
}

