/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.limewire.util.OSUtils;

public class LimeSplitPane
extends JSplitPane {
    private boolean currentlyDraggable = true;

    public LimeSplitPane(int orientation, boolean continuousLayout, Component leftComponent, Component rightComponent, JComponent dividerComponent) {
        super(orientation, continuousLayout, leftComponent, rightComponent);
        BasicSplitPaneUI splitUI = new BasicSplitPaneUI(){

            @Override
            public BasicSplitPaneDivider createDefaultDivider() {
                return new CustomDivider(this);
            }
        };
        this.setUI(splitUI);
        BasicSplitPaneDivider divider = splitUI.getDivider();
        divider.setBorder(BorderFactory.createEmptyBorder());
        divider.setLayout(new BorderLayout());
        divider.removeAll();
        divider.add(dividerComponent);
        this.setDividerSize(dividerComponent.getPreferredSize().height);
        if (OSUtils.isMacOSX()) {
            this.setContinuousLayout(false);
        }
    }

    public void setDragComponent(JComponent component) {
        CustomDivider divider;
        this.assertUISafeForDragabilityChanges();
        CustomDivider customDivider = divider = (CustomDivider)((BasicSplitPaneUI)this.getUI()).getDivider();
        customDivider.getClass();
        CustomDivider.ReroutedMouseHandler reroutedMouseHandler = customDivider.new CustomDivider.ReroutedMouseHandler(component);
        component.addMouseListener(reroutedMouseHandler);
        component.addMouseMotionListener(reroutedMouseHandler);
    }

    public void setDividerDraggable(boolean draggable) {
        this.assertUISafeForDragabilityChanges();
        CustomDivider divider = (CustomDivider)((BasicSplitPaneUI)this.getUI()).getDivider();
        if (!draggable) {
            if (this.currentlyDraggable) {
                this.currentlyDraggable = false;
                divider.setCursor(Cursor.getPredefinedCursor(0));
                divider.removeMouseListener(divider.getMouseHandler());
                divider.removeMouseMotionListener(divider.getMouseHandler());
                this.removeMouseListener(divider.getMouseHandler());
                this.removeMouseMotionListener(divider.getMouseHandler());
            }
        } else if (!this.currentlyDraggable) {
            this.currentlyDraggable = true;
            divider.setCursor(this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
            divider.addMouseListener(divider.getMouseHandler());
            divider.addMouseMotionListener(divider.getMouseHandler());
            this.addMouseListener(divider.getMouseHandler());
            this.addMouseMotionListener(divider.getMouseHandler());
        }
    }

    private void assertUISafeForDragabilityChanges() {
        if (!(this.getUI() instanceof BasicSplitPaneUI)) {
            throw new IllegalStateException("Can't change the divider draggability if the UI has been modified");
        }
        if (!(((BasicSplitPaneUI)this.getUI()).getDivider() instanceof CustomDivider)) {
            throw new IllegalStateException("Can't change the divider draggability if the divider has been modified");
        }
    }

    private static class CustomDivider
    extends BasicSplitPaneDivider {
        public CustomDivider(BasicSplitPaneUI ui) {
            super(ui);
        }

        public BasicSplitPaneDivider.MouseHandler getMouseHandler() {
            return this.mouseHandler;
        }

        public class ReroutedMouseHandler
        extends BasicSplitPaneDivider.MouseHandler {
            private final JComponent rerouteComponent;

            public ReroutedMouseHandler(JComponent rerouteComponent) {
                super(CustomDivider.this);
                this.rerouteComponent = rerouteComponent;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(this.rerouteEvent(e));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(this.rerouteEvent(e));
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(this.rerouteEvent(e));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(this.rerouteEvent(e));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(this.rerouteEvent(e));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(this.rerouteEvent(e));
            }

            private MouseEvent rerouteEvent(MouseEvent e) {
                if (e.getSource() == this.rerouteComponent) {
                    return new MouseEvent(CustomDivider.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                }
                return e;
            }
        }
    }
}

