/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class SideLineBorder
extends AbstractBorder {
    private final Side side;
    private final int thickness;
    private final Color color;

    public SideLineBorder(Color color, Side side) {
        this(color, 1, side);
    }

    public SideLineBorder(Color color, int thickness, Side side) {
        this.color = color;
        this.thickness = thickness;
        this.side = side;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        switch (this.side) {
            case TOP: {
                g.fillRect(x, y, width - 1, this.thickness);
                break;
            }
            case LEFT: {
                g.fillRect(x, y, this.thickness, height);
                break;
            }
            case BOTTOM: {
                g.fillRect(x, y + height - 1 - this.thickness, width - 1, this.thickness);
                break;
            }
            case RIGHT: {
                g.fillRect(x + width - this.thickness, y, this.thickness, height);
            }
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        switch (this.side) {
            case BOTTOM: {
                insets.bottom = this.thickness;
                break;
            }
            case LEFT: {
                insets.left = this.thickness;
                break;
            }
            case RIGHT: {
                insets.right = this.thickness;
                break;
            }
            case TOP: {
                insets.top = this.thickness;
            }
        }
        return insets;
    }

    public Color getLineColor() {
        return this.color;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

