/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jdesktop.application.Resource;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.settings.SharingSettings;
import org.limewire.core.settings.UploadSettings;
import org.limewire.ui.swing.downloads.CancelAllDownloadsAction;
import org.limewire.ui.swing.downloads.CancelAllErrorDownloadAction;
import org.limewire.ui.swing.downloads.CancelAllStalledDownloadAction;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.downloads.PauseAllDownloadAction;
import org.limewire.ui.swing.downloads.ResumeAllDownloadAction;
import org.limewire.ui.swing.downloads.ShowDownloadOptionsAction;
import org.limewire.ui.swing.downloads.ShowUploadsInTrayAction;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class DownloadHeaderPopupMenu
extends JPopupMenu {
    @Resource
    private Icon upArrow;
    @Resource
    private Icon downArrow;
    private final Provider<DownloadMediator> downloadMediator;
    private final Provider<ShowDownloadOptionsAction> showDownloadOptionsAction;
    private final Provider<PauseAllDownloadAction> pauseDownloadAction;
    private final Provider<ResumeAllDownloadAction> resumeDownloadAction;
    private final Provider<CancelAllStalledDownloadAction> cancelStallAction;
    private final Provider<CancelAllErrorDownloadAction> cancelErrorAction;
    private final Provider<CancelAllDownloadsAction> cancelAllAction;
    private final Provider<ShowUploadsInTrayAction> showUploadsInTrayAction;

    @Inject
    public DownloadHeaderPopupMenu(Provider<DownloadMediator> downloadMediator, Provider<ShowDownloadOptionsAction> showDownloadOptionsAction, Provider<PauseAllDownloadAction> pauseDownloadAction, Provider<ResumeAllDownloadAction> resumeDownloadAction, Provider<CancelAllStalledDownloadAction> cancelStallAction, Provider<CancelAllErrorDownloadAction> cancelErrorAction, Provider<CancelAllDownloadsAction> cancelAllAction, Provider<ShowUploadsInTrayAction> showUploadsInTrayAction) {
        this.downloadMediator = downloadMediator;
        this.showDownloadOptionsAction = showDownloadOptionsAction;
        this.pauseDownloadAction = pauseDownloadAction;
        this.resumeDownloadAction = resumeDownloadAction;
        this.cancelStallAction = cancelStallAction;
        this.cancelErrorAction = cancelErrorAction;
        this.cancelAllAction = cancelAllAction;
        this.showUploadsInTrayAction = showUploadsInTrayAction;
        GuiUtils.assignResources(this);
    }

    public void populate() {
        this.removeAll();
        final JCheckBoxMenuItem clearFinishedCheckBox = new JCheckBoxMenuItem(I18n.tr("Clear When Finished"));
        clearFinishedCheckBox.setSelected(SharingSettings.CLEAR_DOWNLOAD.getValue());
        clearFinishedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharingSettings.CLEAR_DOWNLOAD.setValue(clearFinishedCheckBox.isSelected());
            }
        });
        this.add(this.pauseDownloadAction.get()).setEnabled(this.downloadMediator.get().hasPausable());
        this.add(this.resumeDownloadAction.get()).setEnabled(this.downloadMediator.get().hasResumable());
        this.add(this.createCancelSubMenu());
        this.addSeparator();
        this.add(this.createSortSubMenu());
        this.addSeparator();
        this.add(clearFinishedCheckBox);
        this.addSeparator();
        JCheckBoxMenuItem showUploadsInTray = new JCheckBoxMenuItem(this.showUploadsInTrayAction.get());
        showUploadsInTray.setSelected(UploadSettings.SHOW_UPLOADS_IN_TRAY.getValue());
        this.add(showUploadsInTray);
        this.addSeparator();
        this.add(this.showDownloadOptionsAction.get());
    }

    private JMenu createCancelSubMenu() {
        JMenu cancelSubMenu = new JMenu(I18n.tr("Cancel"));
        cancelSubMenu.add(this.cancelStallAction.get()).setEnabled(this.downloadMediator.get().containsState(DownloadState.STALLED));
        cancelSubMenu.add(this.cancelErrorAction.get()).setEnabled(this.downloadMediator.get().containsState(DownloadState.ERROR));
        cancelSubMenu.add(this.cancelAllAction.get()).setEnabled(this.downloadMediator.get().getDownloadList().size() > 0);
        return cancelSubMenu;
    }

    private JMenu createSortSubMenu() {
        JMenu sortSubMenu = new JMenu(I18n.tr("Sort by"));
        JCheckBoxMenuItem orderAdded = new JCheckBoxMenuItem(new SortAction(I18n.tr("Order Added"), DownloadMediator.SortOrder.ORDER_ADDED));
        JCheckBoxMenuItem name = new JCheckBoxMenuItem(new SortAction(I18n.tr("Name"), DownloadMediator.SortOrder.NAME));
        JCheckBoxMenuItem progress = new JCheckBoxMenuItem(new SortAction(I18n.tr("Progress"), DownloadMediator.SortOrder.PROGRESS));
        JCheckBoxMenuItem timeRemaining = new JCheckBoxMenuItem(new SortAction(I18n.tr("Time Left"), DownloadMediator.SortOrder.TIME_REMAINING));
        JCheckBoxMenuItem speed = new JCheckBoxMenuItem(new SortAction(I18n.tr("Speed"), DownloadMediator.SortOrder.SPEED));
        JCheckBoxMenuItem status = new JCheckBoxMenuItem(new SortAction(I18n.tr("Status"), DownloadMediator.SortOrder.STATUS));
        JCheckBoxMenuItem fileType = new JCheckBoxMenuItem(new SortAction(I18n.tr("File Type"), DownloadMediator.SortOrder.FILE_TYPE));
        JCheckBoxMenuItem extension = new JCheckBoxMenuItem(new SortAction(I18n.tr("File Extension"), DownloadMediator.SortOrder.EXTENSION));
        ButtonGroup sortButtonGroup = new ButtonGroup();
        sortButtonGroup.add(orderAdded);
        sortButtonGroup.add(name);
        sortButtonGroup.add(progress);
        sortButtonGroup.add(timeRemaining);
        sortButtonGroup.add(speed);
        sortButtonGroup.add(status);
        sortButtonGroup.add(fileType);
        sortButtonGroup.add(extension);
        JMenuItem reverseButton = new JMenuItem(new AbstractAction(I18n.tr("Reverse Order")){
            {
                this.putValue("SwingSelectedKey", ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).isSortAscending());
                this.putValue("SmallIcon", ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).isSortAscending() ? DownloadHeaderPopupMenu.this.downArrow : DownloadHeaderPopupMenu.this.upArrow);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean direction = !((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).isSortAscending();
                this.putValue("SmallIcon", direction ? DownloadHeaderPopupMenu.this.downArrow : DownloadHeaderPopupMenu.this.upArrow);
                ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).setSortOrder(((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).getSortOrder(), direction);
            }
        });
        sortSubMenu.add(orderAdded);
        sortSubMenu.add(name);
        sortSubMenu.add(progress);
        sortSubMenu.add(timeRemaining);
        sortSubMenu.add(speed);
        sortSubMenu.add(status);
        sortSubMenu.add(fileType);
        sortSubMenu.add(extension);
        sortSubMenu.addSeparator();
        sortSubMenu.add((Component)reverseButton);
        return sortSubMenu;
    }

    private class SortAction
    extends AbstractAction {
        private final DownloadMediator.SortOrder order;

        public SortAction(String title, DownloadMediator.SortOrder order) {
            super(title);
            this.order = order;
            this.putValue("SwingSelectedKey", order == ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).getSortOrder());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).setSortOrder(this.order, ((DownloadMediator)DownloadHeaderPopupMenu.this.downloadMediator.get()).isSortAscending());
        }
    }
}

