/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.ui.swing.downloads.MainDownloadPanel;
import org.limewire.ui.swing.downloads.table.FinishedDownloadSelected;
import org.limewire.ui.swing.downloads.table.LimeWireUiDownloadsTableModule;

public class LimeWireUiDownloadsModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new LimeWireUiDownloadsTableModule());
    }

    @Provides
    @FinishedDownloadSelected
    List<File> selectedFiles(MainDownloadPanel downloadPanel) {
        List<DownloadItem> items = downloadPanel.getSelectedDownloadItems();
        ArrayList<File> files = new ArrayList<File>();
        for (DownloadItem item : items) {
            DownloadState state = item.getState();
            if (state != DownloadState.DONE && state != DownloadState.SCAN_FAILED) continue;
            files.addAll(item.getCompleteFiles());
        }
        return files;
    }
}

