/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.download.DownloadAction;
import org.limewire.core.api.download.DownloadException;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.settings.SearchSettings;
import org.limewire.ui.swing.downloads.DownloadItemUtils;
import org.limewire.ui.swing.downloads.table.AVInfoPanel;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoDialogFactory;
import org.limewire.ui.swing.search.DefaultSearchInfo;
import org.limewire.ui.swing.search.KeywordAssistedSearchBuilder;
import org.limewire.ui.swing.search.SearchHandler;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.util.DownloadExceptionHandler;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.NativeLaunchUtils;
import org.limewire.util.FileUtils;

public class DownloadActionHandler {
    public static final String PAUSE_COMMAND = "pause";
    public static final String CANCEL_COMMAND = "cancel";
    public static final String RESUME_COMMAND = "resume";
    public static final String TRY_AGAIN_COMMAND = "try again";
    public static final String LAUNCH_COMMAND = "launch";
    public static final String PREVIEW_COMMAND = "preview";
    public static final String PLAY_COMMAND = "play";
    public static final String REMOVE_COMMAND = "remove";
    public static final String LOCATE_COMMAND = "locate";
    public static final String LIBRARY_COMMAND = "library";
    public static final String PROPERTIES_COMMAND = "properties";
    public static final String INFO_COMMAND = "info";
    public static final String LINK_COMMAND = "link";
    public static final String SHARE_COMMAND = "share";
    public static final String CHANGE_LOCATION_COMMAND = "change location";
    public static final String SEARCH_AGAIN_COMMAND = "search again";
    private final LibraryMediator libraryMediator;
    private DownloadListManager downloadListManager;
    private LibraryManager libraryManager;
    private final FileInfoDialogFactory fileInfoFactory;
    private final Provider<AVInfoPanel> avInfoPanelFactory;
    private final Provider<DownloadExceptionHandler> downloadExceptionHandler;
    private final SearchHandler searchHandler;
    private final Provider<KeywordAssistedSearchBuilder> searchBuilder;
    private final CategoryManager categoryManager;

    @Inject
    public DownloadActionHandler(DownloadListManager downloadListManager, LibraryMediator libraryMediator, LibraryManager libraryManager, FileInfoDialogFactory fileInfoFactory, Provider<AVInfoPanel> avInfoPanelFactory, Provider<DownloadExceptionHandler> downloadExceptionHandler, SearchHandler searchHandler, Provider<KeywordAssistedSearchBuilder> searchBuilder, CategoryManager categoryManager) {
        this.downloadListManager = downloadListManager;
        this.libraryMediator = libraryMediator;
        this.libraryManager = libraryManager;
        this.fileInfoFactory = fileInfoFactory;
        this.avInfoPanelFactory = avInfoPanelFactory;
        this.downloadExceptionHandler = downloadExceptionHandler;
        this.searchHandler = searchHandler;
        this.searchBuilder = searchBuilder;
        this.categoryManager = categoryManager;
    }

    public void performAction(String actionCommmand, DownloadItem item) {
        if (actionCommmand == CANCEL_COMMAND) {
            item.cancel();
        } else if (actionCommmand == PAUSE_COMMAND) {
            item.pause();
        } else if (actionCommmand == RESUME_COMMAND) {
            item.resume();
        } else if (actionCommmand == TRY_AGAIN_COMMAND) {
            item.resume();
        } else if (actionCommmand != LINK_COMMAND) {
            if (actionCommmand == PREVIEW_COMMAND || actionCommmand == LAUNCH_COMMAND || actionCommmand == PLAY_COMMAND) {
                if (item.isLaunchable()) {
                    DownloadItemUtils.launch(item, this.categoryManager);
                }
            } else if (actionCommmand == LOCATE_COMMAND) {
                if (item.getDownloadingFile() != null) {
                    NativeLaunchUtils.launchExplorer(item.getDownloadingFile());
                }
            } else if (actionCommmand == PROPERTIES_COMMAND) {
                if (item.getState() != DownloadState.DONE && item.getState() != DownloadState.SCAN_FAILED) {
                    FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog(item, FileInfoDialog.FileInfoType.DOWNLOADING_FILE);
                    dialog.setVisible(true);
                } else if (item.getLaunchableFile() != null) {
                    LocalFileItem localItem = this.libraryManager.getLibraryManagedList().getFileItem(item.getLaunchableFile());
                    if (localItem != null) {
                        FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog(localItem, FileInfoDialog.FileInfoType.LOCAL_FILE);
                        dialog.setVisible(true);
                    } else {
                        FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog(item, FileInfoDialog.FileInfoType.DOWNLOADING_FILE);
                        dialog.setVisible(true);
                    }
                } else {
                    FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog(item, FileInfoDialog.FileInfoType.DOWNLOADING_FILE);
                    dialog.setVisible(true);
                }
            } else if (actionCommmand == REMOVE_COMMAND) {
                this.downloadListManager.remove(item);
            } else if (actionCommmand != SHARE_COMMAND) {
                if (actionCommmand == LIBRARY_COMMAND) {
                    this.libraryMediator.locateInLibrary(item);
                } else if (actionCommmand == CHANGE_LOCATION_COMMAND) {
                    this.changeSaveLocation(item);
                } else if (actionCommmand == SEARCH_AGAIN_COMMAND) {
                    this.searchHandler.doSearch(this.createSearchInfo(item));
                } else if (actionCommmand == INFO_COMMAND) {
                    this.showInfoDialog(item);
                }
            }
        }
    }

    private SearchInfo createSearchInfo(DownloadItem item) {
        SearchInfo search;
        String title = item.getPropertyString(FilePropertyKey.TITLE);
        if (title == null) {
            title = FileUtils.getFilenameNoExtension(item.getFileName());
        }
        int maxLength = SearchSettings.MAX_QUERY_LENGTH.getValue();
        if (title.length() > maxLength) {
            title = title.substring(0, maxLength);
        }
        if ((search = this.searchBuilder.get().attemptToCreateAdvancedSearch(title, SearchCategory.forCategory(item.getCategory()))) != null) {
            return search;
        }
        search = DefaultSearchInfo.createKeywordSearch(title, SearchCategory.forCategory(item.getCategory()));
        return search;
    }

    private void changeSaveLocation(DownloadItem item) {
        File saveDir = FileChooser.getInputDirectory(GuiUtils.getMainFrame(), item.getSaveFile().getParentFile());
        if (saveDir == null || saveDir.equals(item.getSaveFile().getParentFile())) {
            return;
        }
        this.setSaveFile(item, saveDir, false);
    }

    private void setSaveFile(DownloadItem item, File saveDir, boolean overwrite) {
        try {
            item.setSaveFile(saveDir, overwrite);
        }
        catch (DownloadException ex) {
            this.downloadExceptionHandler.get().handleDownloadException(new ChangeLocationDownloadAction(item), ex, false);
        }
    }

    private void showInfoDialog(DownloadItem item) {
        block0 : switch (item.getDownloadItemType()) {
            case ANTIVIRUS: {
                this.avInfoPanelFactory.get().showVendorMessage();
                break;
            }
            case GNUTELLA: 
            case BITTORRENT: {
                switch (item.getState()) {
                    case DANGEROUS: {
                        this.avInfoPanelFactory.get().showDangerMessage(item, false);
                        break block0;
                    }
                    case SCANNING: 
                    case SCANNING_FRAGMENT: {
                        this.avInfoPanelFactory.get().showVendorMessage();
                        break block0;
                    }
                    case THREAT_FOUND: {
                        this.avInfoPanelFactory.get().showThreatMessage(item, false);
                        break block0;
                    }
                    case SCAN_FAILED: {
                        this.avInfoPanelFactory.get().showFailureMessage(item, false);
                    }
                }
            }
        }
    }

    private class ChangeLocationDownloadAction
    implements DownloadAction {
        private DownloadItem item;

        ChangeLocationDownloadAction(DownloadItem item) {
            this.item = item;
        }

        @Override
        public void download(File saveFile, boolean overwrite) throws DownloadException {
            DownloadActionHandler.this.setSaveFile(this.item, saveFile, overwrite);
        }

        @Override
        public void downloadCanceled(DownloadException ignored) {
        }
    }
}

