/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.RangeFilterFormat;
import org.limewire.ui.swing.util.I18n;

class BitRateFilterFormat<E extends FilterableItem>
implements RangeFilterFormat<E> {
    private static final long[] RATES = new long[]{0L, 64L, 96L, 128L, 160L, 192L, 256L, 320L, 512L};

    BitRateFilterFormat() {
    }

    @Override
    public String getHeaderText() {
        return I18n.tr("Bitrate");
    }

    @Override
    public Matcher<E> getMatcher(long minValue, long maxValue) {
        return new BitRateMatcher(minValue);
    }

    @Override
    public String getValueText(int valueIndex) {
        return String.valueOf(RATES[valueIndex]);
    }

    @Override
    public long[] getValues() {
        return RATES;
    }

    @Override
    public boolean isMaximumAbsolute() {
        return false;
    }

    @Override
    public boolean isUpperLimitEnabled() {
        return false;
    }

    @Override
    public boolean updateValues(SearchCategory filterCategory, long lowerValue, long upperValue) {
        return false;
    }

    private static class BitRateMatcher<E extends FilterableItem>
    implements Matcher<E> {
        private final long bitRate;

        public BitRateMatcher(long bitRate) {
            this.bitRate = bitRate;
        }

        @Override
        public boolean matches(E item) {
            if (this.bitRate == 0L) {
                return true;
            }
            Object rate = item.getProperty(FilePropertyKey.BITRATE);
            if (rate instanceof Long) {
                return (Long)rate >= this.bitRate;
            }
            return false;
        }
    }
}

