/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Resource;
import org.limewire.friend.api.FriendPresence;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ConversationPanel;
import org.limewire.ui.swing.util.GuiUtils;

class ChatFriendRenderer
extends JLabel
implements TableCellRenderer {
    @Resource
    private Font font;
    @Resource
    private Color fontColor;
    @Resource
    private Color selectionColor;
    @Resource
    private Color lineColor;
    @Resource
    private Icon closeIcon;
    @Resource
    private Icon unviewedMessageIcon;
    @Resource
    private Icon chattingIcon;
    @Resource
    private Icon availableIcon;
    @Resource
    private Icon doNotDisturbIcon;
    @Resource
    private Icon awayIcon;
    private final Border emptyBorder;
    private final Border underlineBorder;
    private final ConversationPanel conversationPanel;

    public ChatFriendRenderer(ConversationPanel conversationPanel) {
        this.conversationPanel = conversationPanel;
        GuiUtils.assignResources(this);
        this.setFont(this.font);
        this.setForeground(this.fontColor);
        this.setBackground(this.selectionColor);
        this.emptyBorder = BorderFactory.createEmptyBorder(0, 2, 1, 2);
        this.underlineBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderFactory.createMatteBorder(0, 0, 1, 0, this.lineColor));
        this.setBorder(this.emptyBorder);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ChatFriend) {
            ChatFriend chatFriend = (ChatFriend)value;
            this.setIcon(this.getIcon(chatFriend, table.getMousePosition(), table.getCellRect(row, column, true), table));
            this.setText(chatFriend.getName());
            if (chatFriend.equals(this.conversationPanel.getCurrentConversationFriend())) {
                this.setBorder(this.underlineBorder);
            } else {
                this.setBorder(this.emptyBorder);
            }
        } else {
            this.setIcon(null);
            this.setText("");
            this.setBorder(this.emptyBorder);
        }
        this.setOpaque(isSelected);
        return this;
    }

    private Icon getIcon(ChatFriend chatFriend, Point mousePosition, Rectangle cellRectangle, JTable table) {
        if (chatFriend.isChatting()) {
            if (this.displayCloseIcon(mousePosition, cellRectangle)) {
                return this.closeIcon;
            }
            if (!chatFriend.equals(this.conversationPanel.getCurrentConversationFriend()) && chatFriend.hasUnviewedMessages()) {
                if (chatFriend.isFlashState()) {
                    return this.chattingIcon;
                }
                return this.unviewedMessageIcon;
            }
            return this.chattingIcon;
        }
        FriendPresence.Mode mode = chatFriend.getMode();
        switch (mode) {
            case available: {
                return this.availableIcon;
            }
            case chat: {
                return this.chattingIcon;
            }
            case dnd: {
                return this.doNotDisturbIcon;
            }
        }
        return this.awayIcon;
    }

    private boolean displayCloseIcon(Point mousePosition, Rectangle cellRectangle) {
        if (mousePosition == null) {
            return false;
        }
        return cellRectangle.contains(mousePosition);
    }
}

