/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.friend.api.FriendPresence;
import org.limewire.ui.swing.components.PopupCloseButton;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.MinimizeAction;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.ResizeUtils;

class ChatHeader {
    @Resource
    private Font textFont;
    @Resource
    private Color textColor;
    @Resource
    private Color background;
    @Resource
    private Icon availableIcon;
    @Resource
    private Icon doNotDisturbIcon;
    @Resource
    private Icon awayIcon;
    private JPanel panel;
    private JLabel friendNameLabel;

    @Inject
    public ChatHeader(MinimizeAction minimizeAction) {
        GuiUtils.assignResources(this);
        this.panel = new JPanel(new MigLayout("insets 0, gap 0, fill"));
        this.panel.setBackground(this.background);
        ResizeUtils.forceHeight(this.panel, 21);
        this.friendNameLabel = new JLabel();
        this.friendNameLabel.setForeground(this.textColor);
        this.friendNameLabel.setFont(this.textFont);
        PopupCloseButton closeButton = new PopupCloseButton(minimizeAction);
        this.panel.add((Component)this.friendNameLabel, "gapleft 4, gapright 2, wmax 360, push");
        this.panel.add((Component)closeButton, "gapright 3");
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void clearFriend() {
        this.friendNameLabel.setText("");
        this.friendNameLabel.setIcon(null);
    }

    public void setFriend(ChatFriend friend) {
        this.friendNameLabel.setText(this.getFriendText(friend));
        this.friendNameLabel.setIcon(this.getIcon(friend.getMode()));
    }

    private Icon getIcon(FriendPresence.Mode mode) {
        switch (mode) {
            case available: {
                return this.availableIcon;
            }
            case dnd: {
                return this.doNotDisturbIcon;
            }
        }
        return this.awayIcon;
    }

    private String getFriendText(ChatFriend chatFriend) {
        if (chatFriend.getStatus() != null && chatFriend.getStatus().length() > 0) {
            return chatFriend.getName() + " - " + chatFriend.getStatus();
        }
        return chatFriend.getName();
    }
}

