/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.limewire.friend.api.Network;
import org.limewire.friend.api.RosterEvent;
import org.limewire.io.UnresolvedIpPort;
import org.limewire.listener.EventListener;
import org.limewire.ui.swing.friends.settings.FriendAccountConfiguration;
import org.limewire.util.StringUtils;

class FriendAccountConfigurationImpl
implements FriendAccountConfiguration {
    private final String resource;
    private final boolean isDebugEnabled;
    private final boolean modifyUser;
    private final boolean requiresDomain;
    private final Icon icon;
    private final Icon largeIcon;
    private volatile String serviceName;
    private volatile String label;
    private volatile String username;
    private volatile String canonicalId;
    private volatile String password;
    private final List<UnresolvedIpPort> defaultServers;
    private final Network.Type type;
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());

    public FriendAccountConfigurationImpl(boolean requireDomain, String serviceName, String label, Icon icon, Icon largeIcon, String resource, List<UnresolvedIpPort> defaultServers, Network.Type type) {
        this(requireDomain, serviceName, label, icon, largeIcon, resource, defaultServers, true, type);
    }

    public FriendAccountConfigurationImpl(String serviceName, String label, String resource, Network.Type type, Icon smallIcon, Icon largeIcon) {
        this(false, serviceName, label, smallIcon, largeIcon, resource, UnresolvedIpPort.EMPTY_LIST, false, type);
    }

    private FriendAccountConfigurationImpl(boolean requireDomain, String serviceName, String label, Icon icon, Icon largeIcon, String resource, List<UnresolvedIpPort> defaultServers, boolean modifyUser, Network.Type type) {
        this.resource = resource;
        this.modifyUser = modifyUser;
        this.type = type;
        this.isDebugEnabled = false;
        this.requiresDomain = requireDomain;
        this.serviceName = serviceName;
        this.label = label;
        this.icon = icon != null ? icon : new EmptyIcon(16, 16);
        this.largeIcon = largeIcon != null ? largeIcon : new EmptyIcon(28, 28);
        this.username = "";
        this.canonicalId = "";
        this.password = "";
        this.defaultServers = defaultServers;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getUserInputLocalID() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.setCanonicalIdFromUsername(username);
        if (this.modifyUser) {
            int at = username.indexOf(64);
            if (this.requiresDomain && at == -1) {
                username = username + "@" + this.getServiceName();
            } else if (!this.requiresDomain && at > -1) {
                username = username.substring(0, at);
            }
        }
        this.username = username;
    }

    void setCanonicalIdFromUsername(String username) {
        int at = username.indexOf(64);
        this.canonicalId = at != -1 ? username.toLowerCase(Locale.US) : (username + "@" + this.getServiceName()).toLowerCase(Locale.US);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean storePassword() {
        return true;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public String getCanonicalizedLocalID() {
        return this.canonicalId;
    }

    @Override
    public String getNetworkName() {
        return this.serviceName;
    }

    @Override
    public Network.Type getType() {
        return this.type;
    }

    @Override
    public EventListener<RosterEvent> getRosterListener() {
        return null;
    }

    public String toString() {
        return StringUtils.toStringBlacklist(this, this.password);
    }

    @Override
    public List<UnresolvedIpPort> getDefaultServers() {
        return this.defaultServers;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object property) {
        this.attributes.put(key, property);
    }

    @Override
    public Icon getLargeIcon() {
        return this.largeIcon;
    }
}

