/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.settings;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.limewire.core.api.xmpp.XMPPResourceFactory;
import org.limewire.friend.api.Network;
import org.limewire.friend.api.PasswordManager;
import org.limewire.inject.LazySingleton;
import org.limewire.io.UnresolvedIpPort;
import org.limewire.io.UnresolvedIpPortImpl;
import org.limewire.ui.swing.friends.settings.FriendAccountConfiguration;
import org.limewire.ui.swing.friends.settings.FriendAccountConfigurationImpl;
import org.limewire.ui.swing.friends.settings.FriendAccountConfigurationManager;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
public class FriendAccountConfigurationManagerImpl
implements FriendAccountConfigurationManager {
    private final PasswordManager passwordManager;
    private final Map<String, FriendAccountConfiguration> configs;
    private final String resource;
    private FriendAccountConfiguration autoLoginConfig = null;
    private boolean loaded = false;
    @Resource
    private Icon gmailIconLarge;
    @Resource
    private Icon gmailIconSmall;
    @Resource
    private Icon ljIconLarge;
    @Resource
    private Icon ljIconSmall;
    @Resource
    private Icon otherIconLarge;
    @Resource
    private Icon otherIconSmall;

    @Inject
    public FriendAccountConfigurationManagerImpl(PasswordManager passwordManager, XMPPResourceFactory xmppResourceFactory) {
        GuiUtils.assignResources(this);
        this.passwordManager = passwordManager;
        this.configs = new HashMap<String, FriendAccountConfiguration>();
        this.resource = xmppResourceFactory.getResource();
    }

    private void init() {
        this.loadWellKnownServers();
        this.loadCustomServer();
        this.loadAutoLoginAccount();
        this.loaded = true;
    }

    private Map<String, FriendAccountConfiguration> getRawConfigs() {
        if (!this.loaded) {
            this.init();
        }
        return this.configs;
    }

    private void loadCustomServer() {
        String custom = SwingUiSettings.USER_DEFINED_JABBER_SERVICENAME.get();
        FriendAccountConfigurationImpl customConfig = new FriendAccountConfigurationImpl(custom, "Jabber", this.resource, Network.Type.XMPP, this.otherIconSmall, this.otherIconLarge);
        this.configs.put(customConfig.getLabel(), customConfig);
    }

    private void loadAutoLoginAccount() {
        String autoLogin = SwingUiSettings.XMPP_AUTO_LOGIN.get();
        if (!autoLogin.equals("")) {
            int comma = autoLogin.indexOf(44);
            try {
                String label = autoLogin.substring(0, comma);
                String username = autoLogin.substring(comma + 1);
                FriendAccountConfiguration config = this.configs.get(label);
                if (config != null) {
                    config.setUsername(username);
                    if (config.storePassword()) {
                        String password = this.passwordManager.loadPassword(username);
                        config.setPassword(password);
                    }
                    this.autoLoginConfig = config;
                }
            }
            catch (IndexOutOfBoundsException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadWellKnownServers() {
        FriendAccountConfigurationImpl gmail = new FriendAccountConfigurationImpl(true, "gmail.com", "Gmail", this.gmailIconSmall, this.gmailIconLarge, this.resource, this.getGTalkServers(), Network.Type.XMPP);
        this.configs.put(gmail.getLabel(), gmail);
        FriendAccountConfigurationImpl livejournal = new FriendAccountConfigurationImpl(false, "livejournal.com", "LiveJournal", this.ljIconSmall, this.ljIconLarge, this.resource, this.getLiveJournalServers(), Network.Type.XMPP);
        this.configs.put(livejournal.getLabel(), livejournal);
    }

    private List<UnresolvedIpPort> getLiveJournalServers() {
        ArrayList<UnresolvedIpPort> defaultServers = new ArrayList<UnresolvedIpPort>(1);
        defaultServers.add(new UnresolvedIpPortImpl("xmpp.services.livejournal.com", 5222));
        return defaultServers;
    }

    private List<UnresolvedIpPort> getGTalkServers() {
        ArrayList<UnresolvedIpPort> defaultServers = new ArrayList<UnresolvedIpPort>(5);
        defaultServers.add(new UnresolvedIpPortImpl("talk.1.google.com", 5222));
        defaultServers.add(new UnresolvedIpPortImpl("talk1.1.google.com", 5222));
        defaultServers.add(new UnresolvedIpPortImpl("talk2.1.google.com", 5222));
        defaultServers.add(new UnresolvedIpPortImpl("talk3.1.google.com", 5222));
        defaultServers.add(new UnresolvedIpPortImpl("talk4.1.google.com", 5222));
        return defaultServers;
    }

    @Override
    public FriendAccountConfiguration getConfig(String label) {
        return this.getRawConfigs().get(label);
    }

    @Override
    public List<FriendAccountConfiguration> getConfigurations() {
        ArrayList<FriendAccountConfiguration> configurations = new ArrayList<FriendAccountConfiguration>(this.getRawConfigs().values());
        Collections.sort(configurations, new Comparator<FriendAccountConfiguration>(){

            @Override
            public int compare(FriendAccountConfiguration o1, FriendAccountConfiguration o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
        return configurations;
    }

    @Override
    public List<String> getLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (FriendAccountConfiguration config : this.getRawConfigs().values()) {
            labels.add(config.getLabel());
        }
        Collections.sort(labels);
        return labels;
    }

    @Override
    public FriendAccountConfiguration getAutoLoginConfig() {
        if (!this.loaded) {
            this.init();
        }
        return this.autoLoginConfig;
    }

    @Override
    public void setAutoLoginConfig(FriendAccountConfiguration config) {
        if (this.autoLoginConfig != null) {
            this.passwordManager.removePassword(this.autoLoginConfig.getUserInputLocalID());
            SwingUiSettings.XMPP_AUTO_LOGIN.set("");
            SwingUiSettings.USER_DEFINED_JABBER_SERVICENAME.set("");
            this.autoLoginConfig = null;
        }
        if (config != null) {
            try {
                if (config.storePassword()) {
                    this.passwordManager.storePassword(config.getUserInputLocalID(), config.getPassword());
                }
                SwingUiSettings.XMPP_AUTO_LOGIN.set(config.getLabel() + "," + config.getUserInputLocalID());
                if (config.getLabel().equals("Jabber")) {
                    SwingUiSettings.USER_DEFINED_JABBER_SERVICENAME.set(config.getServiceName());
                }
                this.autoLoginConfig = config;
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

