/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.swing.JPopupMenu;
import org.limewire.ui.swing.library.AddFileAction;
import org.limewire.ui.swing.library.navigator.ClearAction;
import org.limewire.ui.swing.library.navigator.DeleteListAction;
import org.limewire.ui.swing.library.navigator.ExportListAction;
import org.limewire.ui.swing.library.navigator.ImportListAction;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.navigator.RenameAction;
import org.limewire.ui.swing.util.I18n;

class LibraryNavPopupMenu
extends JPopupMenu {
    private final AddFileAction addAction;
    private final ImportListAction importAction;
    private final ExportListAction exportAction;
    private final Provider<RenameAction> renameAction;
    private final ClearAction clearAction;
    private final Provider<DeleteListAction> deleteAction;

    @Inject
    public LibraryNavPopupMenu(LibraryNavigatorPanel navPanel, AddFileAction addAction, ImportListAction importAction, ExportListAction exportAction, Provider<RenameAction> renameAction, ClearAction clearAction, Provider<DeleteListAction> deleteAction) {
        this.addAction = addAction;
        this.importAction = importAction;
        this.exportAction = exportAction;
        this.renameAction = renameAction;
        this.clearAction = clearAction;
        this.deleteAction = deleteAction;
        this.addAction.putValue("Name", I18n.tr("Add Files..."));
        this.init(navPanel);
    }

    private void init(LibraryNavigatorPanel navPanel) {
        LibraryNavItem item = navPanel.getSelectedNavItem();
        this.add(this.addAction);
        this.addSeparator();
        this.add(this.importAction);
        this.add(this.exportAction);
        this.addSeparator();
        if (item.getType() == LibraryNavItem.NavType.LIBRARY || item.getType() == LibraryNavItem.NavType.PUBLIC_SHARED) {
            this.add(this.clearAction).setEnabled(item.getLocalFileList().size() > 0);
        } else {
            this.add(this.renameAction.get());
            this.addSeparator();
            this.add(this.clearAction).setEnabled(item.getLocalFileList().size() > 0);
            this.add(this.deleteAction.get()).setEnabled(item.getType() == LibraryNavItem.NavType.LIST && navPanel.getPrivateListCount() > 1);
        }
    }
}

