/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.player.Audio;
import org.limewire.ui.swing.player.PlayerMediator;
import org.limewire.ui.swing.util.GuiUtils;

@LazySingleton
class IsPlayingRenderer
extends DefaultTableCellRenderer {
    @Resource
    Icon playingIcon;
    private final Provider<PlayerMediator> playerMediator;
    private final Border emptyBorder;

    @Inject
    public IsPlayingRenderer(@Audio Provider<PlayerMediator> playerMediator) {
        GuiUtils.assignResources(this);
        this.playerMediator = playerMediator;
        this.emptyBorder = BorderFactory.createEmptyBorder(0, 3, 0, 3);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText("");
        this.setBorder(this.emptyBorder);
        if (value instanceof LocalFileItem) {
            if (this.playerMediator.get().isPlaying(((LocalFileItem)value).getFile()) || this.playerMediator.get().isPaused(((LocalFileItem)value).getFile())) {
                this.setIcon(this.playingIcon);
            } else {
                this.setIcon(null);
            }
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

