/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

class RemoveFromLibraryAction
extends AbstractAction {
    private final Provider<List<LocalFileItem>> selectedLocalFileItems;
    private final LibraryManager libraryManager;
    private final SharedFileListManager sharedFileListManager;

    @Inject
    public RemoveFromLibraryAction(@LibrarySelected Provider<List<LocalFileItem>> selectedLocalFileItems, LibraryManager libraryManager, SharedFileListManager sharedFileListManager) {
        super(I18n.tr("All Lists and Library"));
        this.selectedLocalFileItems = selectedLocalFileItems;
        this.libraryManager = libraryManager;
        this.sharedFileListManager = sharedFileListManager;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<LocalFileItem> selected = this.selectedLocalFileItems.get();
        String removeText = I18n.tr("Remove");
        String cancelText = I18n.tr("Cancel");
        Object[] options = new Object[]{removeText, cancelText};
        int confirmation = FocusJOptionPane.showOptionDialog(null, this.getMessage(selected), I18n.trn("Remove File", "Remove Files", selected.size()), 2, 3, null, options, cancelText);
        if (confirmation > -1 && options[confirmation] == removeText) {
            RemoveFromLibraryAction.removeFromLibrary(this.libraryManager, selected);
        }
    }

    private String getMessage(List<LocalFileItem> list) {
        if (list.size() == 1) {
            if (this.containsSharedFile(list)) {
                return I18n.tr("Remove \"{0}\" from Library? This will unshare this file with everyone.", list.get(0).getFileName());
            }
            return I18n.tr("Remove \"{0}\" from Library?", list.get(0).getFileName());
        }
        if (this.containsSharedFile(list)) {
            return I18n.tr("Remove {0} files from Library? This will unshare these files with everyone.", list.size());
        }
        return I18n.tr("Remove {0} files from Library?", list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsSharedFile(List<LocalFileItem> list) {
        boolean hasSharedFile = false;
        this.sharedFileListManager.getModel().getReadWriteLock().readLock().lock();
        try {
            block3: for (SharedFileList sharedFileList : this.sharedFileListManager.getModel()) {
                if (sharedFileList.getFriendIds().size() <= 0) continue;
                for (LocalFileItem item : list) {
                    if (!sharedFileList.contains(item.getFile())) continue;
                    hasSharedFile = true;
                    continue block3;
                }
            }
        }
        finally {
            this.sharedFileListManager.getModel().getReadWriteLock().readLock().unlock();
        }
        return hasSharedFile;
    }

    static void removeFromLibrary(final LibraryManager libraryManager, List<LocalFileItem> selected) {
        File currentSong = PlayerUtils.getCurrentSongFile();
        final ArrayList<File> toRemove = new ArrayList<File>(selected.size());
        for (LocalFileItem item : selected) {
            if (item.getFile().equals(currentSong)) {
                PlayerUtils.stop();
            }
            if (item.isIncomplete()) continue;
            toRemove.add(item.getFile());
        }
        if (!toRemove.isEmpty()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    for (File file : toRemove) {
                        libraryManager.getLibraryManagedList().removeFile(file);
                    }
                }
            });
        }
    }
}

