/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.LibrarySelected;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoDialogFactory;
import org.limewire.ui.swing.util.I18n;

class ViewFileInfoAction
extends AbstractAction {
    private final Provider<List<LocalFileItem>> selectedLocalFileItems;
    private final FileInfoDialogFactory fileInfoFactory;

    @Inject
    public ViewFileInfoAction(@LibrarySelected Provider<List<LocalFileItem>> selectedLocalFileItems, FileInfoDialogFactory fileInfoFactory) {
        super(I18n.tr("View File Info..."));
        this.selectedLocalFileItems = selectedLocalFileItems;
        this.fileInfoFactory = fileInfoFactory;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList localFileItems = new ArrayList(this.selectedLocalFileItems.get());
        if (localFileItems.size() > 0) {
            FileInfoDialog dialog = this.fileInfoFactory.createFileInfoDialog((PropertiableFile)localFileItems.get(0), FileInfoDialog.FileInfoType.LOCAL_FILE);
            dialog.setVisible(true);
        }
    }
}

