/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.upload.UploadListManager;
import org.limewire.ui.swing.mainframe.AppFrame;

public class DelayedShutdownHandler {
    private final GnutellaConnectionManager gnutellaConnectionManager;
    private final DownloadListManager downloadListManager;
    private final UploadListManager uploadListManager;
    private AppFrame appFrame;
    private boolean disconnectOnShutdown;
    private boolean shutdownInitiated;
    private boolean downloadsCompleted;
    private boolean uploadsCompleted;
    private PropertyChangeListener downloadsCompletedListener;
    private PropertyChangeListener uploadsCompletedListener;

    @Inject
    public DelayedShutdownHandler(GnutellaConnectionManager gnutellaConnectionManager, DownloadListManager downloadListManager, UploadListManager uploadListManager) {
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        this.downloadListManager = downloadListManager;
        this.uploadListManager = uploadListManager;
    }

    public void install(AppFrame appFrame) {
        this.appFrame = appFrame;
        appFrame.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent e) {
                DelayedShutdownHandler.this.cancelShutdown();
            }
        });
    }

    public void shutdownAfterTransfers() {
        if (this.shutdownInitiated) {
            return;
        }
        this.shutdownInitiated = true;
        this.disconnectOnShutdown = this.gnutellaConnectionManager.isConnected();
        if (this.disconnectOnShutdown) {
            this.gnutellaConnectionManager.disconnect();
        }
        this.downloadsCompleted = false;
        this.uploadsCompleted = false;
        if (this.downloadsCompletedListener == null) {
            this.downloadsCompletedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("downloadsCompleted".equals(evt.getPropertyName())) {
                        DelayedShutdownHandler.this.downloadsCompleted = true;
                        DelayedShutdownHandler.this.doDelayedShutdown();
                    }
                }
            };
            this.downloadListManager.addPropertyChangeListener(this.downloadsCompletedListener);
        }
        if (this.uploadsCompletedListener == null) {
            this.uploadsCompletedListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("uploadsCompleted".equals(evt.getPropertyName())) {
                        DelayedShutdownHandler.this.uploadsCompleted = true;
                        DelayedShutdownHandler.this.doDelayedShutdown();
                    }
                }
            };
            this.uploadListManager.addPropertyChangeListener(this.uploadsCompletedListener);
        }
        this.downloadListManager.updateDownloadsCompleted();
        this.uploadListManager.updateUploadsCompleted();
        this.appFrame.minimizeToTray();
    }

    private void doDelayedShutdown() {
        if (this.shutdownInitiated && this.downloadsCompleted && this.uploadsCompleted) {
            this.appFrame.exit(new ActionEvent(this, 1001, "Shutdown"));
        }
    }

    public void cancelShutdown() {
        this.shutdownInitiated = false;
        if (this.downloadsCompletedListener != null) {
            this.downloadListManager.removePropertyChangeListener(this.downloadsCompletedListener);
            this.downloadsCompletedListener = null;
        }
        if (this.uploadsCompletedListener != null) {
            this.uploadListManager.removePropertyChangeListener(this.uploadsCompletedListener);
            this.uploadsCompletedListener = null;
        }
        this.downloadsCompleted = false;
        this.uploadsCompleted = false;
        if (this.disconnectOnShutdown) {
            this.gnutellaConnectionManager.connect();
            this.disconnectOnShutdown = false;
        }
    }
}

