/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.mainframe;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavComponent;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.NavSelectable;
import org.limewire.ui.swing.nav.NavigationListener;
import org.limewire.ui.swing.nav.Navigator;

@Singleton
public class MainPanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(MainPanel.class);
    private final Map<String, JComponent> loadedComponents = new HashMap<String, JComponent>();
    private final CardLayout cardLayout = new CardLayout();
    private final Navigator navigator;
    private final String TEMP_CARD = "temporaryComponentCard";
    private JComponent temporaryPanel;

    @Inject
    public MainPanel(Navigator navigator) {
        this.navigator = navigator;
        this.setLayout(this.cardLayout);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainPanel.this.revalidate();
            }
        });
        navigator.addNavigationListener(new NavigationListener(){

            @Override
            public void itemAdded(NavCategory category, NavItem navItem) {
            }

            @Override
            public void itemRemoved(NavCategory category, NavItem navItem, boolean wasSelected) {
                LOG.debugf("Removed item {0}", (Object)navItem);
                JComponent component = (JComponent)MainPanel.this.loadedComponents.get(MainPanel.this.asString(navItem));
                if (component != null) {
                    MainPanel.this.remove(component);
                    MainPanel.this.loadedComponents.remove(MainPanel.this.asString(navItem));
                }
            }

            @Override
            public void itemSelected(NavCategory category, NavItem navItem, NavSelectable selectable, NavMediator navMediator) {
                LOG.debugf("Selected item {0}", (Object)navItem);
                if (navItem != null) {
                    JComponent panel;
                    if (MainPanel.this.temporaryPanel != null) {
                        MainPanel.this.remove(MainPanel.this.temporaryPanel);
                        MainPanel.this.temporaryPanel = null;
                    }
                    if ((panel = (JComponent)MainPanel.this.loadedComponents.get(MainPanel.this.asString(navItem))) == null) {
                        panel = navMediator.getComponent();
                        MainPanel.this.loadedComponents.put(MainPanel.this.asString(navItem), panel);
                        MainPanel.this.add((Component)panel, MainPanel.this.asString(navItem));
                    }
                    MainPanel.this.cardLayout.show(MainPanel.this, MainPanel.this.asString(navItem));
                    if (selectable != null && panel instanceof NavComponent) {
                        NavComponent navComponent = (NavComponent)((Object)panel);
                        navComponent.select(selectable);
                    }
                }
            }

            @Override
            public void categoryAdded(NavCategory category) {
            }

            @Override
            public void categoryRemoved(NavCategory category, boolean wasSelected) {
            }
        });
    }

    public void showTemporaryPanel(JComponent panel) {
        this.navigator.showNothing();
        this.temporaryPanel = panel;
        this.add("temporaryComponentCard", this.temporaryPanel);
        this.cardLayout.show(this, "temporaryComponentCard");
    }

    private String asString(Object key) {
        return System.identityHashCode(key) + "";
    }
}

