/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JMenuItem;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.DownloadSettings;
import org.limewire.setting.FileSetSetting;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.menu.DelayedMnemonicMenu;
import org.limewire.ui.swing.player.PlayerUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

class RecentDownloadsMenu
extends DelayedMnemonicMenu {
    private static final String emptyText = I18n.tr("(empty)");
    private final CategoryManager categoryManager;

    @Inject
    public RecentDownloadsMenu(CategoryManager categoryManager) {
        super(I18n.tr("&Recent Downloads"));
        this.categoryManager = categoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createMenuItems() {
        ArrayList files = null;
        FileSetSetting fileSetSetting = DownloadSettings.RECENT_DOWNLOADS;
        synchronized (fileSetSetting) {
            files = new ArrayList(DownloadSettings.RECENT_DOWNLOADS.get());
        }
        Collections.sort(files, new FileDateMostToLeastRecentComparator());
        if (files.size() > 0) {
            for (File file : files) {
                this.addRecentDownloadAction(file);
            }
            this.addSeparator();
            this.add(new AbstractAction(I18n.tr("Clear List")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DownloadSettings.RECENT_DOWNLOADS.clear();
                }
            });
        } else {
            this.add(new JMenuItem(emptyText)).setEnabled(false);
        }
    }

    private void addRecentDownloadAction(final File file) {
        this.add(new AbstractAction(file.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                Category category = RecentDownloadsMenu.this.categoryManager.getCategoryForFile(file);
                switch (category) {
                    case AUDIO: 
                    case VIDEO: {
                        PlayerUtils.playOrLaunch(file, RecentDownloadsMenu.this.categoryManager);
                        break;
                    }
                    case DOCUMENT: 
                    case IMAGE: {
                        NativeLaunchUtils.safeLaunchFile(file, RecentDownloadsMenu.this.categoryManager);
                        break;
                    }
                    case PROGRAM: 
                    case OTHER: {
                        NativeLaunchUtils.launchExplorer(file);
                        break;
                    }
                }
            }
        });
    }

    private static class FileDateMostToLeastRecentComparator
    implements Comparator<File> {
        private FileDateMostToLeastRecentComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return -1 * Long.valueOf(o1.lastModified()).compareTo(o2.lastModified());
        }
    }
}

