/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.nav;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.ui.swing.nav.NavCategory;
import org.limewire.ui.swing.nav.NavItem;
import org.limewire.ui.swing.nav.NavItemListener;
import org.limewire.ui.swing.nav.NavMediator;
import org.limewire.ui.swing.nav.NavSelectable;
import org.limewire.ui.swing.nav.NavigationListener;
import org.limewire.ui.swing.nav.Navigator;
import org.limewire.util.StringUtils;

@Singleton
class NavigatorImpl
implements Navigator {
    private static final Log LOG = LogFactory.getLog(NavigatorImpl.class);
    private final List<NavigationListener> listeners = new CopyOnWriteArrayList<NavigationListener>();
    private final List<NavItemImpl> navItems = new ArrayList<NavItemImpl>();
    private final Map<NavCategory, Integer> categoryCount = new EnumMap<NavCategory, Integer>(NavCategory.class);
    private final List<NavItemImpl> selectionHistory = new ArrayList<NavItemImpl>();
    private NavItemImpl selectedItem;

    public NavigatorImpl() {
        for (NavCategory category : NavCategory.values()) {
            this.categoryCount.put(category, 0);
        }
    }

    @Override
    public NavItem createNavItem(NavCategory category, String id, NavMediator navMediator) {
        NavItemImpl item = new NavItemImpl(category, id, navMediator);
        this.addNavItem(item);
        return item;
    }

    @Override
    public NavItem getNavItem(NavCategory category, String id) {
        for (NavItemImpl item : this.navItems) {
            LOG.debugf("Returning NavItem for id {0} navItem{1}", (Object)id, (Object)item);
            if (!category.equals((Object)item.category) || !id.equals(item.getId())) continue;
            return item;
        }
        return null;
    }

    @Override
    public boolean hasNavItem(NavCategory category, String id) {
        return this.getNavItem(category, id) != null;
    }

    @Override
    public void addNavigationListener(NavigationListener itemListener) {
        this.listeners.add(itemListener);
        for (NavItemImpl item : this.navItems) {
            itemListener.itemAdded(item.category, item);
        }
    }

    @Override
    public void removeNavigationListener(NavigationListener itemListener) {
        this.listeners.remove(itemListener);
    }

    @Override
    public boolean goBack() {
        if (this.selectionHistory.size() < 2) {
            return false;
        }
        this.selectionHistory.remove(this.selectionHistory.size() - 1);
        NavItem item = this.selectionHistory.remove(this.selectionHistory.size() - 1);
        item.select();
        return true;
    }

    @Override
    public NavItem getSelectedNavItem() {
        return this.selectedItem;
    }

    @Override
    public void showNothing() {
        if (this.selectedItem != null) {
            NavItemImpl item = this.selectedItem;
            this.selectedItem = null;
            item.fireSelected(false);
            for (NavigationListener listener : this.listeners) {
                listener.itemSelected(null, null, null, null);
            }
        }
    }

    private void addNavItem(NavItemImpl item) {
        LOG.debugf("Adding item {0}", (Object)item);
        this.navItems.add(item);
        for (NavigationListener listener : this.listeners) {
            listener.itemAdded(item.category, item);
        }
        this.categoryCount.put(item.category, this.categoryCount.get((Object)item.category) + 1);
        if (this.categoryCount.get((Object)item.category) == 1) {
            for (NavigationListener listener : this.listeners) {
                listener.categoryAdded(item.category);
            }
        }
    }

    private NavItemImpl removeFromHistory(NavItemImpl item) {
        if (!this.selectionHistory.isEmpty()) {
            NavItemImpl priorSelection = null;
            boolean found = false;
            ListIterator<NavItemImpl> iter = this.selectionHistory.listIterator(this.selectionHistory.size());
            while (iter.hasPrevious()) {
                NavItemImpl prior = iter.previous();
                if (prior == item) {
                    iter.remove();
                    found = true;
                    continue;
                }
                if (!found || priorSelection != null) continue;
                priorSelection = prior;
            }
            return priorSelection;
        }
        return null;
    }

    private void addToHistory(NavItemImpl item) {
        this.selectionHistory.add(item);
        if (this.selectionHistory.size() > 10) {
            this.selectionHistory.remove(0);
        }
    }

    private void removeNavItem(NavItemImpl item) {
        if (this.navItems.remove(item)) {
            LOG.debugf("Removed item {0}", (Object)item);
            NavItemImpl priorSelected = this.removeFromHistory(item);
            boolean wasSelected = this.selectedItem == item;
            for (NavigationListener listener : this.listeners) {
                listener.itemRemoved(item.category, item, wasSelected);
                if (!wasSelected) continue;
                listener.itemSelected(null, null, null, null);
            }
            if (wasSelected) {
                this.selectedItem = null;
                item.fireSelected(false);
            }
            item.fireRemoved(wasSelected);
            this.categoryCount.put(item.category, this.categoryCount.get((Object)item.category) - 1);
            if (this.categoryCount.get((Object)item.category) == 0) {
                for (NavigationListener listener : this.listeners) {
                    listener.categoryRemoved(item.category, wasSelected);
                }
            }
            if (wasSelected && priorSelected != null && this.selectedItem == null) {
                assert (priorSelected.valid);
                this.selectNavItem(priorSelected, null, false);
            }
        } else {
            LOG.debugf("Item {0} not contained in list.", (Object)item);
        }
    }

    private void selectNavItem(NavItemImpl item, NavSelectable selectable, boolean addToHistory) {
        if (item != this.selectedItem) {
            if (addToHistory) {
                this.addToHistory(item);
            }
            if (this.selectedItem != null) {
                this.selectedItem.fireSelected(false);
            }
            this.selectedItem = item;
            item.fireSelected(true);
        }
        for (NavigationListener listener : this.listeners) {
            listener.itemSelected(item.category, item, selectable, item.navMediator);
        }
    }

    private class NavItemImpl
    implements NavItem {
        private final List<NavItemListener> listeners = new CopyOnWriteArrayList<NavItemListener>();
        private final NavCategory category;
        private final String id;
        private final NavMediator navMediator;
        private boolean valid = true;

        public NavItemImpl(NavCategory category, String id, NavMediator navMediator) {
            this.category = category;
            this.id = id;
            this.navMediator = navMediator;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void remove() {
            this.valid = false;
            NavigatorImpl.this.removeNavItem(this);
        }

        @Override
        public void select() {
            this.select(null);
        }

        @Override
        public void select(NavSelectable selectable) {
            if (this.valid) {
                NavigatorImpl.this.selectNavItem(this, selectable, true);
            }
        }

        public String toString() {
            return StringUtils.toString(this, new Object[0]);
        }

        @Override
        public void addNavItemListener(NavItemListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeNavItemListener(NavItemListener listener) {
            this.listeners.remove(listener);
        }

        void fireSelected(boolean selected) {
            for (NavItemListener listener : this.listeners) {
                listener.itemSelected(selected);
            }
        }

        void fireRemoved(boolean wasSelected) {
            for (NavItemListener listener : this.listeners) {
                listener.itemRemoved(wasSelected);
            }
        }

        @Override
        public boolean isSelected() {
            return NavigatorImpl.this.selectedItem == this;
        }
    }
}

