/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.limewire.ui.swing.components.ButtonMattePainter;
import org.limewire.ui.swing.options.actions.TabAction;
import org.limewire.ui.swing.util.GuiUtils;

public class FancyOptionTabButton
extends JXButton {
    @Resource
    private Color headerGradientTop;
    @Resource
    private Color headerGradientBottom;
    @Resource
    private Color fontColor;
    @Resource
    private Font font;

    public FancyOptionTabButton(TabAction action) {
        super(action);
        GuiUtils.assignResources(this);
        this.setFont(this.font);
        this.setForeground(this.fontColor);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setIconTextGap(0);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 60));
        this.setGradients(this.headerGradientTop, this.headerGradientBottom);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 12, 4, 12));
        this.setOpaque(false);
    }

    public void setGradients(Color topGradient, Color bottomGradient) {
        this.getAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SwingSelectedKey")) {
                    FancyOptionTabButton.this.repaint();
                }
            }
        });
        final Painter<JXButton> oldPainter = this.getBackgroundPainter();
        GradientPaint paint = new GradientPaint(new Point2D.Double(0.0, 0.0), topGradient, new Point2D.Double(0.0, 1.0), bottomGradient, false);
        this.setBackgroundPainter(new ButtonMattePainter(new MattePainter(paint, true)){

            @Override
            public void paint(Graphics2D g, JXButton component, int width, int height) {
                if (Boolean.TRUE.equals(FancyOptionTabButton.this.getAction().getValue("SwingSelectedKey"))) {
                    super.paint(g, component, width, height - 1);
                } else {
                    oldPainter.paint(g, component, width, height);
                }
            }
        });
    }
}

