/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPasswordField;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.daap.DaapManager;
import org.limewire.core.settings.DaapSettings;
import org.limewire.core.settings.iTunesSettings;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.OKDialogAction;
import org.limewire.ui.swing.util.I18n;

public class ITunesOptionPanel
extends OptionPanel {
    private final JCheckBox addToITunesCheckBox;
    private final DaapManager daapManager;
    private OptionPanel iTunesSharePanel;

    @Inject
    public ITunesOptionPanel(DaapManager daapManager) {
        this.daapManager = daapManager;
        this.setLayout(new MigLayout("gapy 10"));
        this.addToITunesCheckBox = new JCheckBox(I18n.tr("Add audio files I downloaded from LimeWire to iTunes"));
        this.addToITunesCheckBox.setContentAreaFilled(false);
        this.add((Component)this.addToITunesCheckBox, "wrap");
        this.add((Component)this.getITunesSharePanel(), "wrap");
        this.add((Component)new JButton(new OKDialogAction()), "tag ok, gapleft push");
    }

    @Override
    boolean applyOptions() {
        iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(this.addToITunesCheckBox.isSelected());
        return this.getITunesSharePanel().applyOptions();
    }

    @Override
    boolean hasChanged() {
        return iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() != this.addToITunesCheckBox.isSelected() || this.getITunesSharePanel().hasChanged();
    }

    @Override
    public void initOptions() {
        this.getITunesSharePanel().initOptions();
        this.addToITunesCheckBox.setSelected(iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue());
    }

    private OptionPanel getITunesSharePanel() {
        if (this.iTunesSharePanel == null) {
            this.iTunesSharePanel = new ITunesSharePanel();
        }
        return this.iTunesSharePanel;
    }

    private class ITunesSharePanel
    extends OptionPanel {
        private JCheckBox shareWithITunesCheckBox;
        private JCheckBox requirePassWordCheckBox;
        private JPasswordField passwordField;

        public ITunesSharePanel() {
            this.setLayout(new MigLayout("insets 0, gap 0"));
            this.setOpaque(false);
            this.shareWithITunesCheckBox = new JCheckBox(I18n.tr("Share audio and video files in Public Shared list on my local network with iTunes"));
            this.shareWithITunesCheckBox.setContentAreaFilled(false);
            this.shareWithITunesCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ITunesSharePanel.this.setPasswordVisible(ITunesSharePanel.this.shareWithITunesCheckBox.isSelected());
                }
            });
            this.requirePassWordCheckBox = new JCheckBox(I18n.tr("Require password"));
            this.requirePassWordCheckBox.setContentAreaFilled(false);
            this.requirePassWordCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ITunesSharePanel.this.passwordField.setEnabled(ITunesSharePanel.this.requirePassWordCheckBox.isSelected());
                }
            });
            this.passwordField = new JPasswordField(30);
            this.passwordField.setEnabled(false);
            this.add((Component)this.shareWithITunesCheckBox, "split, wrap");
            this.add((Component)this.requirePassWordCheckBox, "gapleft 25, split");
            this.add(this.passwordField);
            this.setPasswordVisible(false);
        }

        @Override
        boolean applyOptions() {
            if (this.hasChanged()) {
                boolean prevEnabled = DaapSettings.DAAP_ENABLED.getValue();
                boolean prevRequiresPassword = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
                String prevPassword = DaapSettings.DAAP_PASSWORD.get();
                boolean requiresPassword = this.requirePassWordCheckBox.isSelected();
                String password = new String(this.passwordField.getPassword());
                if (password.equals("") && requiresPassword) {
                    FocusJOptionPane.showMessageDialog(ITunesOptionPanel.this, I18n.tr("Daap Password cannot be null, iTunes settings not saved"), I18n.tr("iTunes Error"), 0);
                    this.initOptions();
                    return false;
                }
                DaapSettings.DAAP_ENABLED.setValue(this.shareWithITunesCheckBox.isSelected());
                if (!DaapSettings.DAAP_PASSWORD.equals(password)) {
                    DaapSettings.DAAP_PASSWORD.set(password);
                }
                try {
                    if (requiresPassword != prevRequiresPassword || requiresPassword && !password.equals(prevPassword)) {
                        DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(requiresPassword);
                        if (requiresPassword) {
                            ITunesOptionPanel.this.daapManager.disconnectAll();
                        }
                        ITunesOptionPanel.this.daapManager.updateService();
                    }
                    if (this.shareWithITunesCheckBox.isSelected()) {
                        if (prevEnabled) {
                            ITunesOptionPanel.this.daapManager.restart();
                        } else if (!prevEnabled) {
                            ITunesOptionPanel.this.daapManager.start();
                        }
                    } else if (prevEnabled) {
                        ITunesOptionPanel.this.daapManager.stop();
                    }
                }
                catch (IOException err) {
                    DaapSettings.DAAP_ENABLED.setValue(prevEnabled);
                    DaapSettings.DAAP_REQUIRES_PASSWORD.setValue(prevRequiresPassword);
                    DaapSettings.DAAP_PASSWORD.set(prevPassword);
                    ITunesOptionPanel.this.daapManager.stop();
                    this.initOptions();
                    FocusJOptionPane.showMessageDialog(ITunesOptionPanel.this, I18n.tr("Could not restart the Daap connection"), I18n.tr("Daap Error"), 0);
                }
            }
            return false;
        }

        @Override
        boolean hasChanged() {
            return DaapSettings.DAAP_ENABLED.getValue() != this.shareWithITunesCheckBox.isSelected() || DaapSettings.DAAP_REQUIRES_PASSWORD.getValue() != this.requirePassWordCheckBox.isSelected() || this.requirePassWordCheckBox.isSelected() && DaapSettings.DAAP_PASSWORD.get() != this.requirePassWordCheckBox.getText();
        }

        @Override
        public void initOptions() {
            this.shareWithITunesCheckBox.setSelected(DaapSettings.DAAP_ENABLED.getValue());
            this.requirePassWordCheckBox.setSelected(DaapSettings.DAAP_REQUIRES_PASSWORD.getValue());
            if (this.requirePassWordCheckBox.isSelected()) {
                this.passwordField.setText(DaapSettings.DAAP_PASSWORD.get());
            }
            this.setPasswordVisible(this.shareWithITunesCheckBox.isSelected());
        }

        private void setPasswordVisible(boolean value) {
            this.requirePassWordCheckBox.setVisible(value);
            this.passwordField.setVisible(value);
        }
    }
}

