/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import java.awt.Component;
import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.settings.SharingSettings;
import org.limewire.ui.swing.components.NonNullJComboBox;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.util.I18n;

public class LWSFileNamingOptionPanel
extends OptionPanel {
    private JComboBox subFolderComboBox;
    private JComboBox fileNameComboBox;
    private JButton okButton;
    private JButton cancelButton;
    private String oldFileName;
    private String oldSubDirectory;
    private final String artist = I18n.tr("Artist");
    private final String album = I18n.tr("Album");
    private final String track = I18n.tr("Track");
    private final String title = I18n.tr("Title");
    private final String artistVar = "<artist>";
    private final String albumVar = "<album>";
    private final String trackVar = "<track>";
    private final String titleVar = "<title>";

    public LWSFileNamingOptionPanel(Action okAction, CancelDialogAction cancelAction) {
        this.setLayout(new MigLayout("insets 10 10 10 10"));
        cancelAction.setOptionPanel(this);
        this.subFolderComboBox = new NonNullJComboBox(this.getSubDirectoryTemplatesArray());
        this.fileNameComboBox = new NonNullJComboBox(this.getFileNameTemplatesArray());
        this.okButton = new JButton(okAction);
        this.cancelButton = new JButton(cancelAction);
        this.add((Component)new JLabel(I18n.tr("Choose how to organize files you purchased from the LimeWire Store")), "span, gapbottom 11, wrap");
        this.add(new JLabel(I18n.tr("Subfolder")));
        this.add((Component)new JLabel(I18n.tr("File Name")), "wrap");
        this.add((Component)this.subFolderComboBox, "gapBottom 20, gapright 15, growx, pushx 50");
        this.add((Component)this.fileNameComboBox, "gapBottom 20, growx, pushx 50, wrap");
        this.add((Component)this.okButton, "tag ok, skip 1, alignx right, split 2");
        this.add((Component)this.cancelButton, "tag cancel");
    }

    @Override
    boolean applyOptions() {
        String subDirectoryTemplateText = ((ListNode)this.subFolderComboBox.getSelectedItem()).getTemplateText();
        String fileTemplateText = ((ListNode)this.fileNameComboBox.getSelectedItem()).getTemplateText();
        if (!fileTemplateText.equals(this.oldFileName)) {
            SharingSettings.setFileNameLWSTemplate(fileTemplateText);
        }
        if (!subDirectoryTemplateText.equals(this.oldSubDirectory)) {
            SharingSettings.setSubdirectoryLWSTemplate(subDirectoryTemplateText);
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        return !SharingSettings.getFileNameLWSTemplate().equals(this.oldFileName) || !SharingSettings.getSubDirectoryLWSTemplate().equals(this.oldSubDirectory);
    }

    @Override
    public void initOptions() {
        this.oldFileName = SharingSettings.getFileNameLWSTemplate();
        this.oldSubDirectory = SharingSettings.getSubDirectoryLWSTemplate();
        LWSFileNamingOptionPanel.setJComboBox(this.fileNameComboBox, this.getFileNameTemplatesArray(), SharingSettings.getFileNameLWSTemplate());
        LWSFileNamingOptionPanel.setJComboBox(this.subFolderComboBox, this.getSubDirectoryTemplatesArray(), SharingSettings.getSubDirectoryLWSTemplate());
    }

    private ListNode[] getFileNameTemplatesArray() {
        ListNode[] templateOptionStrings = new ListNode[]{new ListNode(this.artist + " - " + this.album + " - " + this.track + " - " + this.title, "<artist> - <album> - <track> - <title>"), new ListNode(this.artist + " - " + this.title, "<artist> - <title>"), new ListNode(this.track + " - " + this.artist + " - " + this.title, "<track> - <artist> - <title>"), new ListNode(this.artist + " - " + this.title + " - " + this.track, "<artist> - <title> - <track>")};
        return templateOptionStrings;
    }

    private ListNode[] getSubDirectoryTemplatesArray() {
        ListNode[] templateOptionStrings = new ListNode[]{new ListNode(this.artist + File.separatorChar + this.album + File.separatorChar, "<artist>" + File.separatorChar + "<album>"), new ListNode(this.album + File.separatorChar, "<album>"), new ListNode(this.artist + File.separatorChar, "<artist>"), new ListNode(I18n.tr("No Subfolder"), "")};
        return templateOptionStrings;
    }

    private static void setJComboBox(JComboBox box, ListNode[] boxList, String subString) {
        int index = 0;
        if (subString != null) {
            for (ListNode node : boxList) {
                if (subString.equals(node.getTemplateText())) break;
                ++index;
            }
        }
        if (index >= boxList.length) {
            index = 0;
        }
        box.setSelectedIndex(index);
    }

    static class ListNode {
        private final String displayText;
        private final String templateText;

        public ListNode(String displayText, String displayTemplateText) {
            this.displayText = displayText;
            this.templateText = displayTemplateText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public String getTemplateText() {
            return this.templateText;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

