/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Application;
import org.limewire.core.settings.SharingSettings;
import org.limewire.ui.swing.options.ITunesOptionPanel;
import org.limewire.ui.swing.options.LearnMoreButton;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.UnsafeTypeOptionPanel;
import org.limewire.ui.swing.options.actions.DialogDisplayAction;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.OSUtils;

public class LibraryOptionPanel
extends OptionPanel {
    @Resource
    private Icon p2pSharedListIcon;
    @Resource
    private Icon sharingMyFilesIcon;
    @Resource
    private Icon sharingArrowIcon;
    private final Application application;
    private final UsePlayerPanel playerPanel;
    private OptionPanel iTunesPanel;
    private OptionPanel sharingPanel;
    private final Provider<UnsafeTypeOptionPanel> unsafeOptionPanelProvider;
    private final Provider<ITunesOptionPanel> iTunesOptionPanelProvider;

    @Inject
    public LibraryOptionPanel(Provider<UnsafeTypeOptionPanel> unsafeTypeOptionPanelProvider, Provider<ITunesOptionPanel> iTunesOptionPanelProvider, Application application) {
        this.application = application;
        this.unsafeOptionPanelProvider = unsafeTypeOptionPanelProvider;
        this.iTunesOptionPanelProvider = iTunesOptionPanelProvider;
        GuiUtils.assignResources(this);
        this.playerPanel = new UsePlayerPanel();
        this.setLayout(new MigLayout("insets 15, fillx, gap 4"));
        this.add((Component)this.getSharingPanel(), "growx, wrap");
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.add((Component)this.getITunesPanel(), "growx, wrap");
        } else {
            this.iTunesPanel = null;
        }
        this.add((Component)this.playerPanel, "wrap");
    }

    @Override
    boolean applyOptions() {
        return this.playerPanel.applyOptions() || this.getSharingPanel().applyOptions() || this.iTunesPanel != null ? this.iTunesPanel.applyOptions() : false;
    }

    @Override
    boolean hasChanged() {
        return this.playerPanel.hasChanged() || this.getSharingPanel().hasChanged() || this.iTunesPanel != null ? this.iTunesPanel.hasChanged() : false;
    }

    @Override
    public void initOptions() {
        this.getSharingPanel().initOptions();
        this.playerPanel.initOptions();
        if (this.iTunesPanel != null) {
            this.iTunesPanel.initOptions();
        }
    }

    private OptionPanel getSharingPanel() {
        if (this.sharingPanel == null) {
            this.sharingPanel = new SharingPanel();
        }
        return this.sharingPanel;
    }

    private OptionPanel getITunesPanel() {
        if (this.iTunesPanel == null) {
            this.iTunesPanel = new ITunesPanel();
        }
        return this.iTunesPanel;
    }

    private class SharingPanel
    extends OptionPanel {
        private final JButton configureButton;
        private final JCheckBox shareP2PdownloadedFilesCheckBox;
        private final UnsafeTypeOptionPanel unsafeTypeOptionPanel;
        private JLabel unsafeMessageLabel;

        public SharingPanel() {
            super(I18n.tr("Sharing"));
            this.unsafeTypeOptionPanel = (UnsafeTypeOptionPanel)LibraryOptionPanel.this.unsafeOptionPanelProvider.get();
            this.shareP2PdownloadedFilesCheckBox = new JCheckBox("<html>" + I18n.tr("Add files I download from P2P Users to my Public Shared List") + "</html>");
            this.shareP2PdownloadedFilesCheckBox.setOpaque(false);
            this.configureButton = new JButton(new DialogDisplayAction(LibraryOptionPanel.this, this.unsafeTypeOptionPanel, I18n.tr("Unsafe File Sharing"), I18n.tr("Configure..."), I18n.tr("Configure unsafe file sharing settings")));
            String learnMoreUrl = "http://www.limewire.com/client_redirect/?page=documentsSharing";
            LearnMoreButton learnMoreButton = new LearnMoreButton("http://www.limewire.com/client_redirect/?page=documentsSharing", LibraryOptionPanel.this.application);
            this.addModifyInfo();
            this.add(this.shareP2PdownloadedFilesCheckBox);
            this.add((Component)new LearnMoreButton("http://www.limewire.com/client_redirect/?page=autoSharingMoreInfo", LibraryOptionPanel.this.application), "gapleft 15, wrap");
            this.unsafeMessageLabel = new JLabel(I18n.tr("Configure unsafe sharing settings"));
            this.add(this.unsafeMessageLabel);
            this.add((Component)learnMoreButton, "gapleft 15");
            this.add((Component)this.configureButton, "gapleft 15");
        }

        private void addModifyInfo() {
            JPanel modifyInfoPanel = new JPanel(new MigLayout("nogrid, insets 0, gap 0"));
            modifyInfoPanel.setOpaque(false);
            JLabel myFiles = new JLabel(I18n.tr("My Files"), LibraryOptionPanel.this.sharingMyFilesIcon, 0);
            myFiles.setVerticalTextPosition(3);
            myFiles.setHorizontalTextPosition(0);
            modifyInfoPanel.add((Component)new JLabel(I18n.tr("To see or modify files in your Public Shared list, go to:")), "gapbottom 10, wrap");
            modifyInfoPanel.add(myFiles);
            modifyInfoPanel.add((Component)new JLabel(LibraryOptionPanel.this.sharingArrowIcon), "aligny top, gaptop 17");
            modifyInfoPanel.add((Component)new JLabel(I18n.tr("Public Shared"), LibraryOptionPanel.this.p2pSharedListIcon, 4), "aligny top, gaptop 15");
            this.add((Component)modifyInfoPanel, "wrap");
        }

        @Override
        boolean applyOptions() {
            SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.setValue(this.shareP2PdownloadedFilesCheckBox.isSelected());
            SharingSettings.ALLOW_PARTIAL_SHARING.setValue(this.shareP2PdownloadedFilesCheckBox.isSelected());
            return this.unsafeTypeOptionPanel.applyOptions();
        }

        @Override
        boolean hasChanged() {
            return SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue() != this.shareP2PdownloadedFilesCheckBox.isSelected() || SharingSettings.ALLOW_PARTIAL_SHARING.getValue() != this.shareP2PdownloadedFilesCheckBox.isSelected() || this.unsafeTypeOptionPanel.hasChanged();
        }

        @Override
        public void initOptions() {
            this.unsafeTypeOptionPanel.initOptions();
            this.shareP2PdownloadedFilesCheckBox.setSelected(SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue());
        }
    }

    private static class UsePlayerPanel
    extends OptionPanel {
        private JCheckBox useLimeWirePlayer;

        public UsePlayerPanel() {
            super("");
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setLayout(new MigLayout("ins 0 0 0 0, gap 0"));
            this.useLimeWirePlayer = new JCheckBox(I18n.tr("Use the LimeWire player when I play Audio and Video files"));
            this.useLimeWirePlayer.setOpaque(false);
            this.add(this.useLimeWirePlayer);
        }

        @Override
        boolean applyOptions() {
            SwingUiSettings.PLAYER_ENABLED.setValue(this.useLimeWirePlayer.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return this.useLimeWirePlayer.isSelected() != SwingUiSettings.PLAYER_ENABLED.getValue();
        }

        @Override
        public void initOptions() {
            this.useLimeWirePlayer.setSelected(SwingUiSettings.PLAYER_ENABLED.getValue());
        }
    }

    private class ITunesPanel
    extends OptionPanel {
        private ITunesOptionPanel iTunesOptionPanel;

        public ITunesPanel() {
            super("iTunes");
            this.iTunesOptionPanel = (ITunesOptionPanel)LibraryOptionPanel.this.iTunesOptionPanelProvider.get();
            JButton configureButton = new JButton(new DialogDisplayAction(LibraryOptionPanel.this, this.iTunesOptionPanel, I18n.tr("iTunes Configuration"), I18n.tr("Configure..."), I18n.tr("Configure iTunes")));
            this.add(new JLabel(I18n.tr("Configure how files in your LimeWire interact with iTunes")));
            this.add((Component)configureButton, "gapleft push");
        }

        @Override
        boolean applyOptions() {
            return this.iTunesOptionPanel.applyOptions();
        }

        @Override
        boolean hasChanged() {
            return this.iTunesOptionPanel.hasChanged();
        }

        @Override
        public void initOptions() {
            this.iTunesOptionPanel.initOptions();
        }
    }
}

