/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.limewire.bittorrent.TorrentManager;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentSettingsAnnotation;
import org.limewire.core.settings.ConnectionSettings;
import org.limewire.ui.swing.components.NumericTextField;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.util.BackgroundExecutorService;
import org.limewire.ui.swing.util.I18n;

public class ProxyOptionPanel
extends OptionPanel {
    private final Provider<TorrentManager> torrentManager;
    private final TorrentManagerSettings torrentSettings;
    private JRadioButton noProxyRadioButton;
    private JRadioButton socksV4RadionButton;
    private JRadioButton socksV5RadioButton;
    private JRadioButton httpRadioButton;
    private ButtonGroup buttonGroup;
    private JTextField proxyTextField;
    private NumericTextField portTextField;
    private JCheckBox authenticationCheckBox;
    private JTextField userNameTextField;
    private JPasswordField passwordField;
    private JLabel proxyLabel;
    private JLabel portLabel;
    private JLabel enableLabel;
    private JLabel userNameLabel;
    private JLabel passwordLabel;

    @Inject
    public ProxyOptionPanel(Provider<TorrentManager> torrentManager, @TorrentSettingsAnnotation TorrentManagerSettings torrentSettings) {
        this.torrentManager = torrentManager;
        this.torrentSettings = torrentSettings;
        this.setLayout(new MigLayout("insets 15 15 15 15, fillx, wrap", "", ""));
        this.setOpaque(false);
        this.add((Component)this.getProxyPanel(), "pushx, growx");
    }

    private JPanel getProxyPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(""));
        p.setLayout(new MigLayout("gapy 10"));
        p.setOpaque(false);
        this.noProxyRadioButton = new JRadioButton(I18n.tr("No Proxy"));
        this.noProxyRadioButton.addItemListener(new ProxyButtonListener());
        this.socksV4RadionButton = new JRadioButton(I18n.tr("Socks v4"));
        this.socksV4RadionButton.addItemListener(new ProxyButtonListener());
        this.socksV5RadioButton = new JRadioButton(I18n.tr("Socks v5"));
        this.socksV5RadioButton.addItemListener(new ProxyButtonListener());
        this.httpRadioButton = new JRadioButton(I18n.tr("HTTP"));
        this.httpRadioButton.addItemListener(new ProxyButtonListener());
        this.noProxyRadioButton.setOpaque(false);
        this.socksV4RadionButton.setOpaque(false);
        this.socksV5RadioButton.setOpaque(false);
        this.httpRadioButton.setOpaque(false);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.noProxyRadioButton);
        this.buttonGroup.add(this.socksV4RadionButton);
        this.buttonGroup.add(this.socksV5RadioButton);
        this.buttonGroup.add(this.httpRadioButton);
        this.proxyTextField = new JTextField(15);
        TextFieldClipboardControl.install(this.proxyTextField);
        this.portTextField = new NumericTextField(5, 0, 65535);
        this.authenticationCheckBox = new JCheckBox();
        this.authenticationCheckBox.setOpaque(false);
        this.authenticationCheckBox.addItemListener(new ProxyButtonListener());
        this.userNameTextField = new JTextField(15);
        TextFieldClipboardControl.install(this.userNameTextField);
        this.passwordField = new JPasswordField(15);
        TextFieldClipboardControl.install(this.passwordField);
        this.proxyLabel = new JLabel(I18n.tr("Proxy:"));
        this.portLabel = new JLabel(I18n.tr("Port:"));
        this.enableLabel = new JLabel(I18n.tr("Enable Authentication"));
        this.userNameLabel = new JLabel(I18n.tr("Username:"));
        this.passwordLabel = new JLabel(I18n.tr("Password:"));
        p.add((Component)this.noProxyRadioButton, "split, wrap");
        p.add((Component)this.socksV4RadionButton, "split, wrap");
        p.add((Component)this.socksV5RadioButton, "split, wrap");
        p.add((Component)this.httpRadioButton, "split, wrap");
        p.add((Component)this.proxyLabel, "split");
        p.add((Component)this.proxyTextField, "gap unrelated");
        p.add(this.portLabel);
        p.add((Component)this.portTextField, "wrap");
        p.add((Component)this.authenticationCheckBox, "gapleft 25, split");
        p.add((Component)this.enableLabel, "wrap");
        p.add((Component)this.userNameLabel, "gapleft 25, split");
        p.add((Component)this.userNameTextField, "wrap");
        p.add((Component)this.passwordLabel, "gapleft 25, split");
        p.add(this.passwordField);
        return p;
    }

    @Override
    boolean applyOptions() {
        int connectionMethod = 0;
        if (this.socksV4RadionButton.isSelected()) {
            connectionMethod = 4;
        } else if (this.socksV5RadioButton.isSelected()) {
            connectionMethod = 5;
        } else if (this.httpRadioButton.isSelected()) {
            connectionMethod = 1;
        }
        int oldProxyPort = ConnectionSettings.PROXY_PORT.getValue();
        int proxyPort = this.portTextField.getValue(oldProxyPort);
        String proxy = this.proxyTextField.getText();
        ConnectionSettings.PROXY_PORT.setValue(proxyPort);
        ConnectionSettings.CONNECTION_METHOD.setValue(connectionMethod);
        ConnectionSettings.PROXY_HOST.set(proxy);
        ConnectionSettings.PROXY_USERNAME.set(this.userNameTextField.getText());
        ConnectionSettings.PROXY_PASS.set(new String(this.passwordField.getPassword()));
        ConnectionSettings.PROXY_AUTHENTICATE.setValue(this.authenticationCheckBox.isSelected());
        if (this.torrentManager.get().isInitialized() && this.torrentManager.get().isValid()) {
            BackgroundExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    ((TorrentManager)ProxyOptionPanel.this.torrentManager.get()).setTorrentManagerSettings(ProxyOptionPanel.this.torrentSettings);
                }
            });
        }
        return false;
    }

    @Override
    boolean hasChanged() {
        int oldProxyPort = ConnectionSettings.PROXY_PORT.getValue();
        if (oldProxyPort != this.portTextField.getValue(oldProxyPort)) {
            return true;
        }
        if (!ConnectionSettings.PROXY_HOST.get().equals(this.proxyTextField.getText())) {
            return true;
        }
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue() != this.authenticationCheckBox.isSelected()) {
            return true;
        }
        if (!ConnectionSettings.PROXY_USERNAME.get().equals(this.userNameTextField.getText())) {
            return true;
        }
        if (!ConnectionSettings.PROXY_PASS.get().equals(this.passwordField.getPassword().toString())) {
            return true;
        }
        switch (ConnectionSettings.CONNECTION_METHOD.getValue()) {
            case 4: {
                return !this.socksV4RadionButton.isSelected();
            }
            case 5: {
                return !this.socksV5RadioButton.isSelected();
            }
            case 1: {
                return !this.httpRadioButton.isSelected();
            }
            case 0: {
                return !this.noProxyRadioButton.isSelected();
            }
        }
        return true;
    }

    @Override
    public void initOptions() {
        int connectionMethod = ConnectionSettings.CONNECTION_METHOD.getValue();
        String proxy = ConnectionSettings.PROXY_HOST.get();
        int proxyPort = ConnectionSettings.PROXY_PORT.getValue();
        this.noProxyRadioButton.setSelected(connectionMethod == 0);
        this.socksV4RadionButton.setSelected(connectionMethod == 4);
        this.socksV5RadioButton.setSelected(connectionMethod == 5);
        this.httpRadioButton.setSelected(connectionMethod == 1);
        this.proxyTextField.setText(proxy);
        this.portTextField.setValue(proxyPort);
        this.authenticationCheckBox.setSelected(ConnectionSettings.PROXY_AUTHENTICATE.getValue());
        this.userNameTextField.setText(ConnectionSettings.PROXY_USERNAME.get());
        this.passwordField.setText(ConnectionSettings.PROXY_PASS.get());
        this.updateState();
    }

    private void updateState() {
        if (this.noProxyRadioButton.isSelected()) {
            this.updateProxy(false);
            this.updateAuthentication(false);
        } else {
            this.updateProxy(true);
            if (this.httpRadioButton.isSelected()) {
                this.updateAuthentication(false);
            } else {
                this.updateAuthentication(true);
            }
        }
    }

    private void updateProxy(boolean value) {
        this.proxyTextField.setEnabled(value);
        this.portTextField.setEnabled(value);
        this.proxyLabel.setVisible(value);
        this.proxyTextField.setVisible(value);
        this.portLabel.setVisible(value);
        this.portTextField.setVisible(value);
    }

    private void updateAuthentication(boolean value) {
        this.authenticationCheckBox.setEnabled(value);
        this.authenticationCheckBox.setVisible(value);
        this.enableLabel.setVisible(value);
        if (this.authenticationCheckBox.isSelected() && this.authenticationCheckBox.isEnabled()) {
            this.userNameTextField.setEnabled(value);
            this.passwordField.setEnabled(value);
            this.userNameLabel.setVisible(value);
            this.userNameTextField.setVisible(value);
            if (this.socksV4RadionButton.isSelected()) {
                this.passwordLabel.setVisible(false);
                this.passwordField.setVisible(false);
            } else {
                this.passwordLabel.setVisible(value);
                this.passwordField.setVisible(value);
            }
        } else {
            this.userNameTextField.setEnabled(false);
            this.passwordField.setEnabled(false);
            this.userNameLabel.setVisible(false);
            this.userNameTextField.setVisible(false);
            this.passwordLabel.setVisible(false);
            this.passwordField.setVisible(false);
        }
    }

    private class ProxyButtonListener
    implements ItemListener {
        private ProxyButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ProxyOptionPanel.this.updateState();
        }
    }
}

