/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options.actions;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.limewire.i18n.I18nMarker;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.LabelTextField;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.FileUtils;

public class BrowseDirectoryAction
extends AbstractAction {
    private Container parent;
    private LabelTextField currentDirectoryTextField;

    public BrowseDirectoryAction(Container parent, LabelTextField currentDirectoryTextField) {
        this.parent = parent;
        this.currentDirectoryTextField = currentDirectoryTextField;
        this.putValue("Name", I18n.tr("Browse..."));
        this.putValue("ShortDescription", I18n.tr("Choose a different Save Location"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String oldDirectory = this.currentDirectoryTextField.getText();
        Window window = FocusJOptionPane.getWindowForComponent(this.parent);
        File directory = FileChooser.getInputDirectory(window, new File(oldDirectory));
        if (directory == null) {
            return;
        }
        FolderErrors error = BrowseDirectoryAction.isSaveDirectoryValid(directory);
        if (error == FolderErrors.SUCCESS) {
            try {
                String newDirectory = directory.getCanonicalPath();
                this.currentDirectoryTextField.setText(newDirectory);
            }
            catch (IOException ioe) {
                FocusJOptionPane.showMessageDialog(window, I18n.tr(error.getErrorMessage(), directory), I18n.tr("Save Folder Error"), 0);
            }
        } else {
            FocusJOptionPane.showMessageDialog(window, I18n.tr(error.getErrorMessage(), directory), I18n.tr("Save Folder Error"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FolderErrors isSaveDirectoryValid(File saveDir) {
        if (saveDir == null) {
            return FolderErrors.CANT_FIND;
        }
        if (saveDir.isFile()) {
            return FolderErrors.NOT_A_FOLDER;
        }
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        if (!saveDir.isDirectory()) {
            return FolderErrors.NOT_A_FOLDER;
        }
        FileUtils.setWriteable(saveDir);
        Random generator = new Random();
        File testFile = null;
        for (int i = 0; i < 10 && testFile == null; ++i) {
            StringBuilder name = new StringBuilder();
            for (int j = 0; j < 8; ++j) {
                name.append((char)(97 + generator.nextInt(25)));
            }
            name.append(".tmp");
            testFile = new File(saveDir, name.toString());
            if (!testFile.exists()) continue;
            testFile = null;
        }
        if (testFile == null) {
            return FolderErrors.CANNOT_WRITE;
        }
        RandomAccessFile testRAFile = null;
        try {
            testRAFile = new RandomAccessFile(testFile, "rw");
            testRAFile.write(7);
            testRAFile.close();
        }
        catch (FileNotFoundException e) {
            FolderErrors folderErrors = FolderErrors.CANNOT_WRITE;
            return folderErrors;
        }
        catch (IOException e) {
            FolderErrors folderErrors = FolderErrors.CANNOT_WRITE;
            return folderErrors;
        }
        finally {
            testFile.delete();
            try {
                if (testRAFile != null) {
                    testRAFile.close();
                }
            }
            catch (IOException ignored) {}
        }
        if (FileUtils.canWrite(saveDir)) {
            return FolderErrors.SUCCESS;
        }
        return FolderErrors.CANNOT_WRITE;
    }

    private static enum FolderErrors {
        NOT_A_FOLDER(I18nMarker.marktr("{0} is not a folder")),
        CANNOT_WRITE(I18nMarker.marktr("Cannot write to {0}")),
        CANT_FIND(I18nMarker.marktr("Cannot find {0}")),
        SUCCESS("");

        private String errorMessage;

        private FolderErrors(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

