/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.painter.factories;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.limewire.activation.api.ActivationManager;
import org.limewire.ui.swing.painter.ProgressBarBackgroundPainter;
import org.limewire.ui.swing.painter.ProgressBarForegroundPainter;
import org.limewire.ui.swing.painter.factories.ProgressPainterFactory;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.PainterUtils;

public class ProgressPainterFactoryImpl
implements ProgressPainterFactory {
    @Resource
    private Color barBorderDisabled = PainterUtils.TRASPARENT;
    @Resource
    private Color barBackgroundGradientTop = PainterUtils.TRASPARENT;
    @Resource
    private Color barBackgroundGradientBottom = PainterUtils.TRASPARENT;
    @Resource
    private Color barDisabledForegroundGradientTop = PainterUtils.TRASPARENT;
    @Resource
    private Color barDisabledForegroundGradientBottom = PainterUtils.TRASPARENT;
    @Resource
    private Color barUpperAccent = PainterUtils.TRASPARENT;
    @Resource
    private Color basicBarBorder = PainterUtils.TRASPARENT;
    @Resource
    private Color basicBarForegroundGradientTop = PainterUtils.TRASPARENT;
    @Resource
    private Color basicBarForegroundGradientBottom = PainterUtils.TRASPARENT;
    @Resource
    private Color proBarBorder = PainterUtils.TRASPARENT;
    @Resource
    private Color proBarForegroundGradientTop = PainterUtils.TRASPARENT;
    @Resource
    private Color proBarForegroundGradientBottom = PainterUtils.TRASPARENT;
    private final ActivationManager activationManager;

    @Inject
    public ProgressPainterFactoryImpl(ActivationManager activationManager) {
        this.activationManager = activationManager;
        GuiUtils.assignResources(this);
    }

    @Override
    public AbstractPainter<JComponent> createBackgroundPainter() {
        if (this.activationManager.isProActive()) {
            return new ProgressBarBackgroundPainter(new GradientPaint(0.0f, 0.0f, this.barBackgroundGradientTop, 0.0f, 1.0f, this.barBackgroundGradientBottom), this.proBarBorder, this.barBorderDisabled);
        }
        return new ProgressBarBackgroundPainter(new GradientPaint(0.0f, 0.0f, this.barBackgroundGradientTop, 0.0f, 1.0f, this.barBackgroundGradientBottom), this.basicBarBorder, this.barBorderDisabled);
    }

    @Override
    public AbstractPainter<JProgressBar> createForegroundPainter() {
        if (this.activationManager.isProActive()) {
            return new ProgressBarForegroundPainter<JProgressBar>((Paint)new GradientPaint(0.0f, 0.0f, this.proBarForegroundGradientTop, 0.0f, 1.0f, this.proBarForegroundGradientBottom), (Paint)new GradientPaint(0.0f, 0.0f, this.barDisabledForegroundGradientTop, 0.0f, 1.0f, this.barDisabledForegroundGradientBottom), this.barUpperAccent);
        }
        return new ProgressBarForegroundPainter<JProgressBar>(new GradientPaint(0.0f, 0.0f, this.basicBarForegroundGradientTop, 0.0f, 1.0f, this.basicBarForegroundGradientBottom), new GradientPaint(0.0f, 0.0f, this.barDisabledForegroundGradientTop, 0.0f, 1.0f, this.barDisabledForegroundGradientBottom));
    }
}

