/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.MetaDataException;
import org.limewire.core.api.library.MetaDataManager;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.properties.PropertyDictionary;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.spam.SpamManager;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.CollectionBackedComboBoxModel;
import org.limewire.ui.swing.components.FilteredDocument;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.listener.MousePopupListener;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.NativeLaunchUtils;

public class FileInfoGeneralPanel
implements FileInfoPanel {
    @Resource
    private Color foreground;
    @Resource
    private Font smallFont;
    @Resource
    private Font mediumFont;
    @Resource
    private Font headerFont;
    private final JPanel component;
    private final FileInfoDialog.FileInfoType type;
    private PropertiableFile propertiableFile;
    private final PropertyDictionary propertyDictionary;
    private final SpamManager spamManager;
    private final MetaDataManager metaDataManager;
    private final LibraryMediator libraryMediator;
    private JTextField locationField;
    private final Map<FilePropertyKey, JComponent> changedProps = new HashMap<FilePropertyKey, JComponent>();

    public FileInfoGeneralPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile, PropertyDictionary propertyDictionary, SpamManager spamManager, MetaDataManager metaDataManager, LibraryMediator libraryMediator) {
        this.type = type;
        this.propertiableFile = propertiableFile;
        this.propertyDictionary = propertyDictionary;
        this.spamManager = spamManager;
        this.metaDataManager = metaDataManager;
        this.libraryMediator = libraryMediator;
        this.component = new JPanel(new MigLayout("fillx"));
        GuiUtils.assignResources(this);
        this.init();
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return this.changedProps.size() != 0 && this.propertiableFile instanceof LocalFileItem;
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
        this.propertiableFile = file;
        String path = ((LocalFileItem)this.propertiableFile).getFile().getAbsolutePath();
        this.locationField.setText(path);
        this.locationField.setToolTipText(path);
        this.locationField.setCaretPosition(0);
    }

    @Override
    public void save() {
        switch (this.type) {
            case LOCAL_FILE: {
                if (!this.hasChanged()) break;
                LocalFileItem item = (LocalFileItem)this.propertiableFile;
                HashMap<FilePropertyKey, Object> newData = new HashMap<FilePropertyKey, Object>();
                for (FilePropertyKey key : this.changedProps.keySet()) {
                    JComponent component = this.changedProps.get((Object)key);
                    if (component instanceof JTextComponent) {
                        newData.put(key, ((JTextComponent)component).getText().trim());
                        continue;
                    }
                    if (!(component instanceof JComboBox)) continue;
                    newData.put(key, ((JComboBox)component).getSelectedItem());
                }
                try {
                    this.metaDataManager.save(item, newData);
                    break;
                }
                catch (MetaDataException e) {
                    String message = I18n.tr("Unable to save metadata changes.");
                    FocusJOptionPane.showMessageDialog(GuiUtils.getMainFrame(), message, I18n.tr("View File Info"), 1);
                }
            }
        }
    }

    @Override
    public void dispose() {
    }

    private void init() {
        this.component.setOpaque(false);
        this.createError();
        if (this.propertiableFile.getCategory() != Category.OTHER) {
            this.createEditableDetails();
        }
        this.createLocation();
        URN urn = this.propertiableFile.getUrn();
        if (urn != null) {
            this.component.add((Component)this.createHeaderLabel(I18n.tr("Hash")), "wrap");
            this.component.add((Component)this.createLabelField(((Object)this.propertiableFile.getUrn()).toString()), "growx, span, wrap");
        }
    }

    private void createError() {
        if (this.propertiableFile instanceof DownloadItem) {
            TorrentStatus status;
            DownloadItem downloadItem = (DownloadItem)this.propertiableFile;
            Torrent torrent = (Torrent)downloadItem.getDownloadProperty(DownloadPropertyKey.TORRENT);
            TorrentStatus torrentStatus = status = torrent != null ? torrent.getStatus() : null;
            if (status != null && status.isError()) {
                this.component.add((Component)this.createHeaderLabel(I18n.tr("Error")), "span, gaptop 15, wrap");
                this.component.add((Component)this.createLabelField(status.getError()), "span, growx, wrap");
            }
        }
    }

    private void createEditableDetails() {
        this.component.add((Component)this.createHeaderLabel(I18n.tr("Details")), "span, wrap");
        JScrollPane descriptionScrollPane = new JScrollPane(this.createEditableTextArea(this.propertiableFile.getPropertyString(FilePropertyKey.DESCRIPTION), FilePropertyKey.DESCRIPTION), 20, 31);
        switch (this.propertiableFile.getCategory()) {
            case AUDIO: {
                this.component.add((Component)this.createPlainLabel(I18n.tr("Title")), "growx, pushx 100");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Artist")), "growx, span 3, pushx 50, wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.TITLE), FilePropertyKey.TITLE), "growx, pushx 100, gapright unrelated");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.AUTHOR), FilePropertyKey.AUTHOR), "growx, span 3, pushx 50, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Album")), "pushx 100");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Genre")), "pushx 17");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Year")), "pushx 17");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Track")), "pushx 17, wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.ALBUM), FilePropertyKey.ALBUM), "growx, pushx 100, gapright unrelated");
                this.component.add((Component)this.createEditableComboBox(this.propertiableFile.getPropertyString(FilePropertyKey.GENRE), this.getGenres(this.propertiableFile), FilePropertyKey.GENRE), "growx, pushx 17, gapright unrelated");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.YEAR), FilePropertyKey.YEAR), "growx, pushx 17, wmin 35, gapright unrelated");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.TRACK_NUMBER), FilePropertyKey.TRACK_NUMBER), "growx, wmin 35, pushx 17, wrap");
                break;
            }
            case VIDEO: {
                this.component.add((Component)this.createPlainLabel(I18n.tr("Title")), "wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.TITLE), FilePropertyKey.TITLE), "span, growx, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Genre")), "pushx 35");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Rating")), "pushx 35");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Year")), "pushx 30, wrap");
                this.component.add((Component)this.createEditableComboBox(this.propertiableFile.getPropertyString(FilePropertyKey.GENRE), this.getGenres(this.propertiableFile), FilePropertyKey.GENRE), "growx, pushx 35, gapright unrelated");
                this.component.add((Component)this.createEditableComboBox(this.propertiableFile.getPropertyString(FilePropertyKey.RATING), this.getRatings(this.propertiableFile), FilePropertyKey.RATING), "growx, pushx 35, gapright unrelated");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.YEAR), FilePropertyKey.YEAR), "growx, wmin 35, pushx 30, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Description")), "wrap");
                this.component.add((Component)descriptionScrollPane, "span, growx, hmin 42, wrap");
                break;
            }
            case IMAGE: {
                this.component.add((Component)this.createPlainLabel(I18n.tr("Title")), "wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.TITLE), FilePropertyKey.TITLE), "span, growx, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Description")), "wrap");
                this.component.add((Component)descriptionScrollPane, "span, growx, hmin 42, wrap");
                break;
            }
            case DOCUMENT: {
                this.component.add((Component)this.createPlainLabel(I18n.tr("Author")), "wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.AUTHOR), FilePropertyKey.AUTHOR), "span, growx, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Description")), "wrap");
                this.component.add((Component)descriptionScrollPane, "span, growx, hmin 42, wrap");
                break;
            }
            case PROGRAM: {
                this.component.add((Component)this.createPlainLabel(I18n.tr("Title")), "wrap");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.TITLE), FilePropertyKey.TITLE), "growx, span, wrap");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Platform")), "growx 30");
                this.component.add((Component)this.createPlainLabel(I18n.tr("Company")), "growx 70, wrap");
                this.component.add((Component)this.createEditableComboBox(this.propertiableFile.getPropertyString(FilePropertyKey.PLATFORM), this.getPlatforms(this.propertiableFile), FilePropertyKey.PLATFORM), "growx 30, gapright 5");
                this.component.add((Component)this.createEditableTextField(this.propertiableFile.getPropertyString(FilePropertyKey.COMPANY), FilePropertyKey.COMPANY), "growx 70, wrap");
                break;
            }
        }
    }

    private void createLocation() {
        switch (this.type) {
            case LOCAL_FILE: {
                if (!(this.propertiableFile instanceof LocalFileItem)) break;
                HyperlinkButton locateOnDisk = new HyperlinkButton(new AbstractAction(I18n.tr("Locate on Disk")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NativeLaunchUtils.launchExplorer(((LocalFileItem)FileInfoGeneralPanel.this.propertiableFile).getFile());
                    }
                });
                HyperlinkButton locateInLibrary = new HyperlinkButton(new AbstractAction(I18n.tr("Locate in Library")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileInfoGeneralPanel.this.component.getRootPane().getParent().setVisible(false);
                        FileInfoGeneralPanel.this.libraryMediator.selectInLibrary(((LocalFileItem)FileInfoGeneralPanel.this.propertiableFile).getFile());
                    }
                });
                this.component.add((Component)this.createHeaderLabel(I18n.tr("Location")), "gaptop 15");
                this.component.add((Component)locateOnDisk, "span, alignx right, split");
                this.component.add((Component)locateInLibrary, "gapleft 15, wrap");
                this.locationField = this.createLabelField("");
                this.updatePropertiableFile(this.propertiableFile);
                this.component.add((Component)this.locationField, "span, growx, wrap");
                break;
            }
            case REMOTE_FILE: {
                this.component.add((Component)this.createHeaderLabel(I18n.tr("Location")), "span, gaptop 15, wrap");
                if (this.propertiableFile instanceof VisualSearchResult) {
                    final ReadOnlyTableModel model = new ReadOnlyTableModel();
                    final MouseableTable table = new MouseableTable(model);
                    model.setColumnIdentifiers(new Object[]{I18n.tr("Name"), I18n.tr("Address"), I18n.tr("Filename")});
                    for (SearchResult result : ((VisualSearchResult)this.propertiableFile).getCoreSearchResults()) {
                        for (RemoteHost host : result.getSources()) {
                            Friend f = host.getFriendPresence().getFriend();
                            model.addRow(new Object[]{f.getRenderName(), f.getName(), result.getFileName()});
                        }
                    }
                    this.component.add((Component)new JScrollPane(table), "span, grow, wrap");
                    table.addMouseListener(new MousePopupListener(){

                        @Override
                        public void handlePopupMouseEvent(final MouseEvent e) {
                            JPopupMenu blockingMenu = new JPopupMenu();
                            blockingMenu.add(new AbstractAction(I18n.tr("Block Address")){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    int blockRow = table.rowAtPoint(e.getPoint());
                                    table.getSelectionModel().setSelectionInterval(blockRow, blockRow);
                                    Object value = model.getValueAt(blockRow, 1);
                                    if (value != null) {
                                        FileInfoGeneralPanel.this.addToFilterList(value.toString());
                                    }
                                }
                            });
                            blockingMenu.show(table, e.getX(), e.getY());
                        }
                    });
                    break;
                }
                if (!(this.propertiableFile instanceof SearchResult)) break;
                String friend = ((SearchResult)((Object)this.propertiableFile)).getSources().get(0).getFriendPresence().getFriend().getRenderName();
                this.component.add((Component)this.createLabelField(friend), "span, growx, wrap");
                break;
            }
            case DOWNLOADING_FILE: {
                if (!(this.propertiableFile instanceof DownloadItem)) break;
                File launchableFile = ((DownloadItem)this.propertiableFile).getDownloadingFile();
                HyperlinkButton locateOnDisk2 = new HyperlinkButton(new AbstractAction(I18n.tr("Locate on Disk")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (((DownloadItem)FileInfoGeneralPanel.this.propertiableFile).getDownloadingFile() != null) {
                            NativeLaunchUtils.launchExplorer(((DownloadItem)FileInfoGeneralPanel.this.propertiableFile).getDownloadingFile());
                        }
                    }
                });
                HyperlinkButton locateInLibrary2 = new HyperlinkButton(new AbstractAction(I18n.tr("Locate in Library")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileInfoGeneralPanel.this.component.getRootPane().getParent().setVisible(false);
                        DownloadItem item = (DownloadItem)FileInfoGeneralPanel.this.propertiableFile;
                        FileInfoGeneralPanel.this.libraryMediator.locateInLibrary(item);
                    }
                });
                this.component.add((Component)this.createHeaderLabel(I18n.tr("Location")), "gaptop 15");
                this.component.add((Component)locateOnDisk2, "span, alignx right, split");
                this.component.add((Component)locateInLibrary2, "gapleft 15, wrap");
                if (launchableFile != null && launchableFile.getAbsoluteFile() != null) {
                    this.component.add((Component)this.createLabelField(launchableFile.getAbsolutePath()), "span, growx, wrap");
                    break;
                }
                this.component.add((Component)this.createLabelField(this.propertiableFile.getFileName()), "span, growx, wrap");
            }
        }
    }

    private JLabel createPlainLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.smallFont);
        label.setForeground(this.foreground);
        return label;
    }

    private JLabel createHeaderLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.headerFont);
        label.setForeground(this.foreground);
        return label;
    }

    private JTextField createEditableTextField(String text, FilePropertyKey key) {
        JTextField field = new JTextField();
        TextFieldClipboardControl.install(field);
        if (this.type != FileInfoDialog.FileInfoType.LOCAL_FILE) {
            field.setEditable(false);
        } else {
            this.changedProps.put(key, field);
            FilteredDocument.configure(field, key);
        }
        field.setCaretPosition(0);
        field.setFont(this.mediumFont);
        field.setForeground(this.foreground);
        field.setText(text);
        return field;
    }

    private JTextArea createEditableTextArea(String text, FilePropertyKey key) {
        JTextArea area = new JTextArea(text);
        TextFieldClipboardControl.install(area);
        if (this.type != FileInfoDialog.FileInfoType.LOCAL_FILE) {
            area.setEditable(false);
            area.setBackground(UIManager.getLookAndFeel().getDefaults().getColor("TextField.disabledBackground"));
        } else {
            this.changedProps.put(key, area);
        }
        area.setFont(this.mediumFont);
        area.setForeground(this.foreground);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        return area;
    }

    private List<String> getGenres(PropertiableFile propertiableSeed) {
        switch (propertiableSeed.getCategory()) {
            case AUDIO: {
                return this.propertyDictionary.getAudioGenres();
            }
            case VIDEO: {
                return this.propertyDictionary.getVideoGenres();
            }
        }
        return Collections.emptyList();
    }

    private JComponent createEditableComboBox(String selection, List<String> model, FilePropertyKey key) {
        if (this.type != FileInfoDialog.FileInfoType.LOCAL_FILE) {
            return this.createEditableTextField(selection, null);
        }
        JComboBox comboBox = new JComboBox();
        this.changedProps.put(key, comboBox);
        this.setupComboBox(comboBox, selection, model);
        return comboBox;
    }

    private void setupComboBox(JComboBox comboBox, String current, List<String> possibles) {
        if (current == null) {
            current = "";
        }
        comboBox.setForeground(this.foreground);
        if (!possibles.contains(current) && !current.equals("") && possibles.size() > 0) {
            possibles = new ArrayList<String>(possibles);
            possibles.add(0, current);
            possibles = Collections.unmodifiableList(possibles);
        }
        CollectionBackedComboBoxModel model = new CollectionBackedComboBoxModel(possibles);
        comboBox.setModel(model);
        comboBox.setSelectedItem(current);
    }

    private List<String> getRatings(PropertiableFile propertiableSeed) {
        switch (propertiableSeed.getCategory()) {
            case VIDEO: {
                return this.propertyDictionary.getVideoRatings();
            }
        }
        return Collections.emptyList();
    }

    private List<String> getPlatforms(PropertiableFile propertiableSeed) {
        switch (propertiableSeed.getCategory()) {
            case PROGRAM: {
                return this.propertyDictionary.getApplicationPlatforms();
            }
        }
        return Collections.emptyList();
    }

    private void addToFilterList(String ipAddress) {
        this.spamManager.addToBlackList(ipAddress);
    }

    private JTextField createLabelField(String text) {
        JTextField field = new JTextField(text);
        TextFieldClipboardControl.install(field);
        field.setCaretPosition(0);
        field.setEditable(false);
        field.setOpaque(false);
        field.setFont(this.smallFont);
        field.setForeground(this.foreground);
        field.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        return field;
    }

    private static class ReadOnlyTableModel
    extends DefaultTableModel {
        private ReadOnlyTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

