/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.limewire.bittorrent.Torrent;
import org.limewire.bittorrent.TorrentTracker;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadPropertyKey;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadPropertyKey;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.components.decorators.TableDecorator;
import org.limewire.ui.swing.library.table.RemoveButton;
import org.limewire.ui.swing.properties.FileInfoDialog;
import org.limewire.ui.swing.properties.FileInfoPanel;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.I18n;

public class FileInfoTrackersPanel
implements FileInfoPanel {
    private static final int URL_COLUMN = 0;
    private static final int TIER_COLUMN = 1;
    private static final int REMOVE_COLUMN = 2;
    private final Torrent torrent;
    private final JPanel component = new JPanel(new MigLayout("fillx, gap 0, insets 0 0 20 0"));
    private List<TorrentTracker> trackerList = null;
    private JXTable table;

    public FileInfoTrackersPanel(FileInfoDialog.FileInfoType type, PropertiableFile propertiableFile, TableDecorator tableDecorator) {
        if (propertiableFile instanceof DownloadItem) {
            this.torrent = (Torrent)((DownloadItem)propertiableFile).getDownloadProperty(DownloadPropertyKey.TORRENT);
        } else if (propertiableFile instanceof UploadItem) {
            this.torrent = (Torrent)((UploadItem)propertiableFile).getUploadProperty(UploadPropertyKey.TORRENT);
        } else {
            this.torrent = null;
            this.table = null;
            return;
        }
        this.trackerList = this.torrent.getTrackers();
        if (this.trackerList == null) {
            return;
        }
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return I18n.tr("URL");
                }
                if (columnIndex == 1) {
                    return I18n.tr("Tier");
                }
                return "";
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ((TorrentTracker)FileInfoTrackersPanel.this.trackerList.get(rowIndex)).getURL();
                }
                if (columnIndex == 1) {
                    return ((TorrentTracker)FileInfoTrackersPanel.this.trackerList.get(rowIndex)).getTier();
                }
                if (columnIndex == 2) {
                    return rowIndex;
                }
                throw new IllegalArgumentException("Invalid Column Used");
            }

            @Override
            public int getRowCount() {
                return FileInfoTrackersPanel.this.trackerList.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }
        };
        this.table = new JXTable(model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }
        };
        tableDecorator.decorate(this.table);
        this.table.setCellSelectionEnabled(false);
        this.table.setShowGrid(false, false);
        this.table.setSortable(false);
        TableColumn tierColumn = this.table.getColumn(1);
        tierColumn.setMaxWidth(45);
        tierColumn.setMinWidth(25);
        tierColumn.setWidth(40);
        tierColumn.setPreferredWidth(40);
        TableColumn removeColumn = this.table.getColumn(2);
        removeColumn.setCellRenderer(new RemoveRenderer());
        removeColumn.setCellEditor(new RemoveEditor());
        removeColumn.setMaxWidth(12);
        removeColumn.setMinWidth(12);
        removeColumn.setWidth(12);
        removeColumn.setPreferredWidth(12);
        DefaultLimeTableCellRenderer tierRenderer = new DefaultLimeTableCellRenderer();
        tierRenderer.setHorizontalAlignment(0);
        tierColumn.setCellRenderer(tierRenderer);
        JLabel addTrackerLabel = new JLabel(I18n.tr("Add Tracker:"));
        final JTextField trackerUrlTextField = new JTextField(100);
        JLabel tierLabel = new JLabel(I18n.tr("Tier:"));
        final JSpinner tierSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
        final JLabel errorLabel = new JLabel(I18n.tr("Tracker URL Invalid"));
        errorLabel.setForeground(Color.RED);
        errorLabel.setVisible(false);
        JButton addButton = new JButton(new AbstractAction(I18n.tr("Add")){

            @Override
            public void actionPerformed(ActionEvent event) {
                int tier;
                String url = trackerUrlTextField.getText().trim();
                if (FileInfoTrackersPanel.this.addTracker(url, tier = ((Integer)tierSpinner.getValue()).intValue())) {
                    FileInfoTrackersPanel.this.refreshTable();
                    trackerUrlTextField.setText("");
                    tierSpinner.setValue(0);
                    errorLabel.setVisible(false);
                } else {
                    errorLabel.setVisible(true);
                }
            }
        });
        TextFieldClipboardControl.install(trackerUrlTextField);
        JFormattedTextField tierSpinnerTextField = ((JSpinner.DefaultEditor)tierSpinner.getEditor()).getTextField();
        tierSpinnerTextField.setEditable(false);
        this.component.add((Component)new JScrollPane(this.table), "gaptop 10, gapbottom 6, span, grow, wrap");
        this.component.add((Component)addTrackerLabel, "gapright 5");
        this.component.add((Component)trackerUrlTextField, "growx, gapright 10");
        this.component.add((Component)tierLabel, "gapright 5");
        this.component.add((Component)tierSpinner, "gapright 10");
        this.component.add((Component)addButton, "wrap");
        this.component.add((Component)errorLabel, "hidemode 3");
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void updatePropertiableFile(PropertiableFile file) {
    }

    @Override
    public void dispose() {
    }

    private void refreshTable() {
        this.trackerList = this.torrent.getTrackers();
        this.table.repaint();
    }

    private boolean addTracker(String url, int tier) {
        boolean duplicate = false;
        for (TorrentTracker tracker : this.trackerList) {
            if (!tracker.getURL().equals(url)) continue;
            duplicate = true;
            break;
        }
        if (!duplicate) {
            try {
                new URL(url);
                this.torrent.addTracker(url, tier);
                return true;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean removeTracker(int row) {
        if (row == 0) {
            return false;
        }
        TorrentTracker tracker = this.trackerList.get(row);
        if (tracker != null) {
            this.torrent.removeTracker(tracker.getURL(), tracker.getTier());
            return true;
        }
        return false;
    }

    private class RemoveEditor
    extends JPanel
    implements TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private int currentRow = -1;
        private final RemoveButton button = new RemoveButton();

        public RemoveEditor() {
            this.button.removeActionHandListener();
            this.button.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FileInfoTrackersPanel.this.removeTracker(RemoveEditor.this.currentRow)) {
                        RemoveEditor.this.cancelCellEditing();
                        FileInfoTrackersPanel.this.refreshTable();
                    }
                }
            });
            this.add(this.button);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                this.currentRow = (Integer)value;
                this.button.setVisible(this.currentRow != 0);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(lis)) {
                    this.listeners.add(lis);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingCanceled(new ChangeEvent(this));
                }
            }
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCellEditorListener(CellEditorListener lis) {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.contains(lis)) {
                    this.listeners.remove(lis);
                }
            }
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean stopCellEditing() {
            List<CellEditorListener> list = this.listeners;
            synchronized (list) {
                int N = this.listeners.size();
                for (int i = 0; i < N; ++i) {
                    this.listeners.get(i).editingStopped(new ChangeEvent(this));
                }
            }
            return true;
        }
    }

    private class RemoveRenderer
    extends JPanel
    implements TableCellRenderer {
        private final RemoveButton button = new RemoveButton();

        public RemoveRenderer() {
            this.add(this.button);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                int currentRow = (Integer)value;
                this.button.setVisible(currentRow != 0);
            }
            return this;
        }
    }
}

