/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.api.search.browse.BrowseStatusListener;
import org.limewire.ui.swing.search.SearchInfo;
import org.limewire.ui.swing.search.SearchResultsPanel;
import org.limewire.ui.swing.search.SearchResultsPanelFactory;
import org.limewire.ui.swing.search.model.SearchResultsModel;
import org.limewire.ui.swing.search.model.SearchResultsModelFactory;
import org.limewire.ui.swing.util.SwingUtils;

public class BrowsePanelFactory {
    private SearchResultsModelFactory searchResultsModelFactory;
    private SearchResultsPanelFactory searchResultsPanelFactory;

    @Inject
    public BrowsePanelFactory(SearchResultsModelFactory searchResultsModelFactory, SearchResultsPanelFactory searchResultsPanelFactory) {
        this.searchResultsModelFactory = searchResultsModelFactory;
        this.searchResultsPanelFactory = searchResultsPanelFactory;
    }

    public SearchResultsPanel createBrowsePanel(BrowseSearch search, SearchInfo searchInfo) {
        SearchResultsModel searchModel = this.searchResultsModelFactory.createSearchResultsModel(searchInfo, search);
        SearchResultsPanel searchPanel = this.searchResultsPanelFactory.createSearchResultsPanel(searchModel);
        search.addBrowseStatusListener(new SearchPanelBrowseStatusListener(searchPanel));
        return searchPanel;
    }

    private static class SearchPanelBrowseStatusListener
    implements BrowseStatusListener {
        private SearchResultsPanel searchPanel;

        public SearchPanelBrowseStatusListener(SearchResultsPanel searchPanel) {
            this.searchPanel = searchPanel;
        }

        @Override
        public void statusChanged(final BrowseStatus status) {
            SwingUtils.invokeNowOrLater(new Runnable(){

                @Override
                public void run() {
                    SearchPanelBrowseStatusListener.this.searchPanel.setBrowseStatus(status);
                }
            });
        }
    }
}

