/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.friend.api.FriendPresence;
import org.limewire.ui.swing.search.FriendPresenceActions;
import org.limewire.ui.swing.util.I18n;

public class RemoteHostMenuFactory {
    private final Provider<FriendPresenceActions> remoteHostActions;

    @Inject
    public RemoteHostMenuFactory(Provider<FriendPresenceActions> remoteHostActions) {
        this.remoteHostActions = remoteHostActions;
    }

    public JMenu createBrowseMenu(Collection<RemoteHost> allHosts) {
        TreeSet<RemoteHost> uniqueHosts = new TreeSet<RemoteHost>(new RemoteHostComparator());
        uniqueHosts.addAll(allHosts);
        JMenu browse = new JMenu(I18n.tr("Browse Files"));
        for (RemoteHost host : uniqueHosts) {
            browse.add(new BrowseAction(host));
        }
        return browse;
    }

    private static class RemoteHostComparator
    implements Comparator<RemoteHost> {
        private RemoteHostComparator() {
        }

        @Override
        public int compare(RemoteHost o1, RemoteHost o2) {
            return o1.getFriendPresence().getPresenceId().compareTo(o2.getFriendPresence().getPresenceId());
        }
    }

    private class BrowseAction
    extends AbstractAction {
        private FriendPresence presence;

        public BrowseAction(RemoteHost host) {
            super(host.getFriendPresence().getFriend().getRenderName());
            this.presence = host.getFriendPresence();
            this.setEnabled(host.isBrowseHostEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((FriendPresenceActions)RemoteHostMenuFactory.this.remoteHostActions.get()).viewLibrariesOf(Collections.singleton(this.presence));
        }
    }
}

