/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.core.api.library.FriendAutoCompleterFactory;
import org.limewire.core.api.search.SearchCategory;
import org.limewire.core.settings.SearchSettings;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.DropDownListAutoCompleteControl;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.components.LimeComboBox;
import org.limewire.ui.swing.components.PromptTextField;
import org.limewire.ui.swing.components.decorators.ComboBoxDecorator;
import org.limewire.ui.swing.components.decorators.TextFieldDecorator;
import org.limewire.ui.swing.painter.BorderPainter;
import org.limewire.ui.swing.search.HistoryAndFriendAutoCompleter;
import org.limewire.ui.swing.search.SearchCategoryUtils;
import org.limewire.ui.swing.search.SearchNavItem;
import org.limewire.ui.swing.search.SearchNavigator;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.I18NConvert;

public class SearchBar
extends JXPanel {
    @Resource
    private Color searchBorder;
    private final LimeComboBox comboBox;
    private final PromptTextField searchField;
    private final IconButton searchButton;
    private final HistoryAndFriendAutoCompleter autoCompleter;
    private final FriendAutoCompleterFactory friendAutoCompleterFactory;
    private final AutoCompleteDictionary searchHistory;
    private final SearchNavigator searchNavigator;
    private SearchCategory categoryToSearch;
    @InspectablePrimitive(value="search bar category switched", category=DataCategory.USAGE)
    private static volatile int categorySwitched = 0;

    @Inject
    public SearchBar(ComboBoxDecorator comboBoxDecorator, FriendAutoCompleterFactory friendAutoCompleterFactory, @Named(value="searchHistory") AutoCompleteDictionary searchHistory, CategoryIconManager categoryIconManager, TextFieldDecorator textFieldDecorator, SearchNavigator searchNavigator) {
        super(new MigLayout("ins 0, gapx 0, gapy 0"));
        GuiUtils.assignResources(this);
        this.friendAutoCompleterFactory = friendAutoCompleterFactory;
        this.searchNavigator = searchNavigator;
        this.searchHistory = searchHistory;
        this.autoCompleter = new HistoryAndFriendAutoCompleter();
        this.categoryToSearch = SearchCategory.forId(SwingUiSettings.DEFAULT_SEARCH_CATEGORY_ID.getValue());
        CategoryAction actionToSelect = null;
        LinkedList<Action> typeActions = new LinkedList<Action>();
        for (SearchCategory cat : SearchCategory.values()) {
            if (cat == SearchCategory.OTHER) continue;
            Icon icon = null;
            if (cat != SearchCategory.ALL) {
                icon = categoryIconManager.getIcon(cat.getCategory());
            }
            CategoryAction action = new CategoryAction(cat, icon);
            if (cat == this.categoryToSearch) {
                actionToSelect = action;
            }
            typeActions.add(action);
        }
        this.comboBox = new LimeComboBox(typeActions);
        comboBoxDecorator.decorateLightFullComboBox(this.comboBox);
        this.comboBox.setName("SearchBar.comboBox");
        this.addAdvancedSearch(this.comboBox);
        this.searchField = new PromptTextField(I18n.tr("Search..."));
        textFieldDecorator.decoratePromptField(this.searchField, BorderPainter.AccentType.BUBBLE, (Paint)this.searchBorder);
        this.searchField.setName("SearchBar.searchField");
        this.searchField.setDocument(new SearchFieldDocument());
        this.searchButton = new IconButton();
        this.searchButton.removeActionHandListener();
        this.searchButton.setName("SearchBar.searchButton");
        this.searchButton.setFocusPainted(false);
        this.searchButton.setToolTipText(I18n.tr("Search P2P Network"));
        DropDownListAutoCompleteControl autoCompleteControl = DropDownListAutoCompleteControl.install(this.searchField, this.autoCompleter);
        autoCompleteControl.setAutoComplete(true);
        this.autoCompleter.setHistoryDictionary(searchHistory);
        this.addSearchActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchText = SearchBar.this.getSearchText();
                if (!searchText.isEmpty() && SwingUiSettings.KEEP_SEARCH_HISTORY.getValue()) {
                    SearchBar.this.searchHistory.addEntry(searchText);
                }
            }
        });
        SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchBar.this.autoCompleter.setSuggestionsShown(SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.getValue());
                    }
                });
            }
        });
        this.autoCompleter.setSuggestionsShown(SwingUiSettings.SHOW_FRIEND_SUGGESTIONS.getValue());
        if (actionToSelect != null) {
            this.autoCompleter.setSuggestionDictionary(friendAutoCompleterFactory.getDictionary(this.categoryToSearch));
            this.comboBox.setSelectedAction(actionToSelect);
        } else {
            this.autoCompleter.setSuggestionDictionary(friendAutoCompleterFactory.getDictionary(SearchCategory.ALL));
        }
        this.setOpaque(false);
        this.add(this.comboBox);
        this.add((Component)this.searchField, "gap 5");
        this.add((Component)this.searchButton, "gap 5");
    }

    private void addAdvancedSearch(LimeComboBox comboBox) {
        comboBox.addMenuCreationListener(new LimeComboBox.MenuCreationListener(){

            @Override
            public void menuCreated(LimeComboBox comboBox, final JPopupMenu menu) {
                menu.addSeparator();
                menu.add(new HyperlinkButton(new AbstractAction(I18n.tr("Advanced Search")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchNavItem navItem = SearchBar.this.searchNavigator.addAdvancedSearch();
                        navItem.select();
                        menu.setVisible(false);
                    }
                }));
            }
        });
    }

    @Inject
    void register(ListenerSupport<FriendConnectionEvent> connectionSupport) {
        connectionSupport.addListener(new EventListener<FriendConnectionEvent>(){

            @Override
            @SwingEDTEvent
            public void handleEvent(FriendConnectionEvent event) {
                switch ((FriendConnectionEvent.Type)((Object)event.getType())) {
                    case CONNECTED: {
                        SearchBar.this.searchButton.setToolTipText(I18n.tr("Search P2P Network and Friends"));
                        break;
                    }
                    default: {
                        SearchBar.this.searchButton.setToolTipText(I18n.tr("Search P2P Network"));
                    }
                }
            }
        });
    }

    public boolean requestSearchFocus() {
        return this.searchField.requestFocus(true);
    }

    public void selectAllSearchText() {
        this.searchField.setCaretPosition(this.searchField.getDocument().getLength());
        this.searchField.selectAll();
    }

    public void setText(String text) {
        this.searchField.setText(text);
    }

    public void setCategory(SearchCategory category) {
        for (Action a : this.comboBox.getActions()) {
            CategoryAction categoryAction;
            if (!(a instanceof CategoryAction) || (categoryAction = (CategoryAction)a).getCategory() != category) continue;
            this.comboBox.setSelectedAction(categoryAction);
            categoryAction.actionPerformed(null);
            return;
        }
    }

    public void addSearchActionListener(ActionListener actionListener) {
        this.searchField.addActionListener(actionListener);
        this.searchButton.addActionListener(actionListener);
    }

    public String getSearchText() {
        String searchText = this.searchField.getText();
        return searchText != null ? searchText.trim() : "";
    }

    public SearchCategory getCategory() {
        return this.categoryToSearch;
    }

    private static class SearchFieldDocument
    extends PlainDocument {
        private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();

        private SearchFieldDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (offs >= MAX_QUERY_LENGTH) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String norm = I18NConvert.instance().getNorm(str);
            if (this.getMaxLength() + Math.max(str.length(), norm.length()) > MAX_QUERY_LENGTH) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(offs, str, a);
        }

        private int getMaxLength() {
            try {
                String text = this.getText(0, this.getLength());
                return Math.max(text.length(), I18NConvert.instance().getNorm(text).length());
            }
            catch (BadLocationException e) {
                return 0;
            }
        }
    }

    private class CategoryAction
    extends AbstractAction {
        private final SearchCategory category;

        CategoryAction(SearchCategory category, Icon icon) {
            super(SearchCategoryUtils.getName(category));
            this.putValue("SmallIcon", icon);
            this.category = category;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SearchBar.this.categoryToSearch = this.category;
            SearchBar.this.autoCompleter.setSuggestionDictionary(SearchBar.this.friendAutoCompleterFactory.getDictionary(this.category));
            categorySwitched++;
        }

        public SearchCategory getCategory() {
            return this.category;
        }
    }
}

