/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search.resultpanel.classic;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.search.model.VisualSearchResult;
import org.limewire.ui.swing.search.resultpanel.ResultsTableFormat;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.table.TrackComparator;
import org.limewire.ui.swing.util.I18n;

public class AudioTableFormat
extends ResultsTableFormat<VisualSearchResult> {
    static final int FROM_INDEX = 0;
    static final int TITLE_INDEX = 1;
    static final int ARTIST_INDEX = 2;
    static final int ALBUM_INDEX = 3;
    public static final int LENGTH_INDEX = 4;
    public static final int QUALITY_INDEX = 5;
    static final int BITRATE_INDEX = 6;
    static final int GENRE_INDEX = 7;
    static final int TRACK_INDEX = 8;
    static final int YEAR_INDEX = 9;
    static final int NAME_INDEX = 10;
    static final int EXTENSION_INDEX = 11;
    public static final int SIZE_INDEX = 12;
    static final int DESCRIPTION_INDEX = 13;
    static final int IS_SPAM_INDEX = 14;

    public AudioTableFormat() {
        super("CLASSIC_SEARCH_AUDIO_TABLE", 1, 0, 14, new ColumnStateInfo(0, "CLASSIC_SEARCH_AUDIO_FROM", I18n.tr("From"), 88, true, true), new ColumnStateInfo(1, "CLASSIC_SEARCH_AUDIO_TITLE", I18n.tr("Name"), 255, true, true), new ColumnStateInfo(2, "CLASSIC_SEARCH_AUDIO_ARTIST", I18n.tr("Artist"), 174, true, true), new ColumnStateInfo(3, "CLASSIC_SEARCH_AUDIO_ALBUM", I18n.tr("Album"), 157, true, true), new ColumnStateInfo(4, "CLASSIC_SEARCH_AUDIO_LENGTH", I18n.tr("Length"), 64, true, true), new ColumnStateInfo(5, "CLASSIC_SEARCH_AUDIO_QUALITY", I18n.tr("Quality"), 105, true, true), new ColumnStateInfo(6, "CLASSIC_SEARCH_AUDIO_BITRATE", I18n.tr("Bitrate"), 55, false, true), new ColumnStateInfo(7, "CLASSIC_SEARCH_AUDIO_GENRE", I18n.tr("Genre"), 80, false, true), new ColumnStateInfo(8, "CLASSIC_SEARCH_AUDIO_TRACK", I18n.tr("Track"), 60, false, true), new ColumnStateInfo(9, "CLASSIC_SEARCH_AUDIO_YEAR", I18n.tr("Year"), 60, false, true), new ColumnStateInfo(10, "CLASSIC_SEARCH_AUDIO_NAME", I18n.tr("Filename"), 550, false, true), new ColumnStateInfo(11, "CLASSIC_SEARCH_AUDIO_EXTENSION", I18n.tr("Extension"), 60, false, true), new ColumnStateInfo(12, "CLASSIC_SEARCH_AUDIO_SIZE", I18n.tr("Size"), 80, false, true), new ColumnStateInfo(13, "CLASSIC_SEARCH_AUDIO_DESCRIPTION", I18n.tr("Description"), 60, false, false), new ColumnStateInfo(14, "CLASSIC_SEARCH_AUDIO_IS_SPAM", "", 10, false, false));
    }

    @Override
    public Class getColumnClass(int column) {
        switch (column) {
            case 1: {
                return Component.class;
            }
            case 6: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 0: {
                return VisualSearchResult.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 8: {
                return this.getTrackComparator();
            }
            case 5: {
                return this.getQualityComparator();
            }
        }
        return super.getColumnComparator(column);
    }

    @Override
    public Object getColumnValue(VisualSearchResult vsr, int column) {
        switch (column) {
            case 0: {
                return vsr;
            }
            case 1: {
                return vsr;
            }
            case 2: {
                return vsr.getProperty(FilePropertyKey.AUTHOR);
            }
            case 3: {
                return vsr.getProperty(FilePropertyKey.ALBUM);
            }
            case 4: {
                return vsr.getProperty(FilePropertyKey.LENGTH);
            }
            case 5: {
                return vsr;
            }
            case 6: {
                return vsr.getProperty(FilePropertyKey.BITRATE);
            }
            case 7: {
                return vsr.getProperty(FilePropertyKey.GENRE);
            }
            case 8: {
                return vsr.getProperty(FilePropertyKey.TRACK_NUMBER);
            }
            case 9: {
                return vsr.getProperty(FilePropertyKey.YEAR);
            }
            case 10: {
                return vsr.getProperty(FilePropertyKey.NAME);
            }
            case 11: {
                return vsr.getFileExtension();
            }
            case 12: {
                return vsr.getSize();
            }
            case 13: {
                return "";
            }
            case 14: {
                return vsr;
            }
        }
        throw new IllegalArgumentException("Unknown column:" + column);
    }

    @Override
    public List<SortKey> getDefaultSortKeys() {
        if (TablesHandler.getSortedColumn(this.getSortOrderID(), this.getSortedColumn()).getValue() == this.getSortedColumn() && TablesHandler.getSortedOrder(this.getSortOrderID(), this.getSortOrder()).getValue() == this.getSortOrder()) {
            return Arrays.asList(new SortKey(SortOrder.DESCENDING, 0), new SortKey(SortOrder.ASCENDING, 2), new SortKey(SortOrder.ASCENDING, 3), new SortKey(SortOrder.ASCENDING, 8), new SortKey(SortOrder.ASCENDING, 1));
        }
        return super.getDefaultSortKeys();
    }

    @Override
    public List<Integer> getSecondarySortColumns(int column) {
        switch (column) {
            case 2: {
                return Arrays.asList(3, 8, 1);
            }
            case 3: {
                return Arrays.asList(8, 1);
            }
        }
        return Collections.emptyList();
    }

    public Comparator getTrackComparator() {
        return new TrackComparator();
    }
}

