/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.shell;

import java.io.IOException;
import org.limewire.ui.swing.shell.ShellAssociation;

abstract class WindowsAssociation
implements ShellAssociation {
    protected final String executable;

    protected WindowsAssociation(String executable) {
        this.executable = executable;
    }

    @Override
    public boolean isAvailable() {
        try {
            return "".equals(this.get());
        }
        catch (IOException readFailed) {
            return false;
        }
    }

    @Override
    public boolean isRegistered() {
        try {
            return this.executable.equals(this.get());
        }
        catch (IOException readFailed) {
            return false;
        }
    }

    protected abstract String get() throws IOException;

    protected static String parsePath(String value) {
        int end;
        int begin;
        if ("".equals(value)) {
            return "";
        }
        if (value.startsWith("\"")) {
            begin = 1;
            end = value.indexOf("\"", begin);
        } else {
            begin = 0;
            end = value.indexOf(" ");
        }
        if (end == -1) {
            return value;
        }
        return value.substring(begin, end);
    }
}

