/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.limewire.ui.swing.table.AquaMouseListenerProxy;

public class BasicJXTable
extends JXTable {
    private AquaMouseListenerProxy proxyMouseListener;

    public BasicJXTable() {
        this.initialize();
    }

    public BasicJXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public BasicJXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public BasicJXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public BasicJXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public BasicJXTable(TableModel dm) {
        super(dm);
        this.initialize();
    }

    public BasicJXTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    private void initialize() {
        this.getActionMap().remove("find");
        this.setEnterKeyAction(null);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (this.proxyMouseListener == null && AquaMouseListenerProxy.isAquaMouseListener(mouseListener)) {
            this.proxyMouseListener = new AquaMouseListenerProxy(mouseListener);
            super.addMouseListener(this.proxyMouseListener);
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (this.proxyMouseListener != null && mouseListener == this.proxyMouseListener.getPeer()) {
            super.removeMouseListener(this.proxyMouseListener);
            this.proxyMouseListener = null;
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    public void setEnterKeyAction(Action action) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "launchAction");
        this.getActionMap().put("launchAction", action);
    }
}

