/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.limewire.ui.swing.table.StripedJXTreeTable;
import org.limewire.ui.swing.table.TableColors;
import org.limewire.ui.swing.util.PropertyUtils;

public class MouseableTreeTable
extends StripedJXTreeTable {
    private final TableColors colors = this.newTableColors();
    private boolean stripesPainted = false;
    private MouseMotionListener mouseOverEditorListener;

    public MouseableTreeTable() {
        this.initialize();
    }

    public MouseableTreeTable(TreeTableModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    protected TableColors newTableColors() {
        return new TableColors();
    }

    public TableColors getTableColors() {
        return this.colors;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int col = this.columnAtPoint(event.getPoint());
        if (row > -1 && col > -1) {
            Object value = this.getValueAt(row, col);
            JComponent renderer = this.getRendererComponent(row, col, value);
            if (value != null && this.isClipped(renderer, col)) {
                String toolTip = renderer.getToolTipText();
                if (toolTip != null) {
                    return toolTip;
                }
                if (renderer instanceof JLabel) {
                    return ((JLabel)renderer).getText();
                }
                return PropertyUtils.getToolTipText(value);
            }
        }
        return null;
    }

    private boolean isClipped(JComponent renderer, int col) {
        return renderer.getPreferredSize().width > this.getColumnModel().getColumn(col).getWidth();
    }

    private JComponent getRendererComponent(int row, int col, Object value) {
        TableCellRenderer tcr = this.getCellRenderer(row, col);
        return (JComponent)tcr.getTableCellRendererComponent(this, value, false, false, row, col);
    }

    @Override
    public int getEditingRow() {
        return this.editingColumn != -1 && this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    protected void initialize() {
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.getSelectionMapper().setEnabled(false);
        this.setHighlighters(this.colors.getEvenHighlighter(), this.colors.getOddHighlighter());
        this.setGridColor(this.colors.getGridColor());
        this.mouseOverEditorListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col;
                int row = MouseableTreeTable.this.rowAtPoint(e.getPoint());
                if (MouseableTreeTable.this.isCellEditable(row, col = MouseableTreeTable.this.columnAtPoint(e.getPoint())) && (row != MouseableTreeTable.this.getEditingRow() || col != MouseableTreeTable.this.getEditingColumn())) {
                    MouseableTreeTable.this.editCellAt(row, col);
                } else {
                    MouseableTreeTable.this.maybeCancelEditing();
                }
            }
        };
        this.addMouseMotionListener(this.mouseOverEditorListener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableCellEditor editor;
                int col = MouseableTreeTable.this.columnAtPoint(e.getPoint());
                int row = MouseableTreeTable.this.rowAtPoint(e.getPoint());
                if (row >= 0 && col >= 0 && MouseableTreeTable.this.isCellEditable(row, col) && (editor = MouseableTreeTable.this.getCellEditor(row, col)) != null) {
                    MouseableTreeTable.this.prepareEditor(editor, row, col);
                    MouseableTreeTable.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseableTreeTable.this.maybeCancelEditing();
            }
        });
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            this.removeEditor();
        }
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        if (this.compoundHighlighter != null) {
            ComponentAdapter adapter = this.getComponentAdapter(row, column);
            comp = this.compoundHighlighter.highlight(comp, adapter);
        }
        return comp;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (row >= this.getRowCount() || col >= this.getColumnCount() || row < 0 || col < 0) {
            return false;
        }
        return this.getColumnModel().getColumn(col).getCellEditor() != null;
    }

    public void setStripesPainted(boolean painted) {
        this.stripesPainted = painted;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.stripesPainted) {
            super.paintEmptyRows(g);
        }
    }

    private void maybeCancelEditing() {
        Point mousePosition = this.getMousePosition();
        if (this.getCellEditor() != null && (mousePosition == null || this.rowAtPoint(mousePosition) == -1 || this.columnAtPoint(mousePosition) == -1)) {
            this.getCellEditor().cancelCellEditing();
        }
    }
}

