/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import com.google.inject.Inject;
import java.awt.Component;
import javax.swing.JTable;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.table.DefaultLimeTableCellRenderer;
import org.limewire.ui.swing.util.I18n;

@LazySingleton
public class NameRenderer
extends DefaultLimeTableCellRenderer {
    @Inject
    public NameRenderer() {
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String name = null;
        if (value != null && value instanceof LocalFileItem) {
            LocalFileItem localFileItem = (LocalFileItem)value;
            name = this.getName(localFileItem);
        }
        if (name != null) {
            this.setText(name);
        } else {
            this.setText("");
        }
        return this;
    }

    private String getName(LocalFileItem localFileItem) {
        String name = null;
        if (localFileItem.getCategory() == Category.AUDIO) {
            name = localFileItem.getPropertyString(FilePropertyKey.TITLE);
        } else if (localFileItem.getCategory() == Category.VIDEO) {
            name = localFileItem.getFileName();
        }
        if (name == null) {
            name = localFileItem.getPropertyString(FilePropertyKey.NAME);
        }
        if (name == null) {
            name = localFileItem.getFileName();
        }
        if (name != null && localFileItem.isIncomplete()) {
            name = I18n.tr("{0} (downloading)", name);
        }
        return name;
    }
}

