/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.library.PropertiableFile;
import org.limewire.inject.LazySingleton;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.ui.swing.util.PropertiableHeadings;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

@LazySingleton
class PropertiableHeadingsImpl
implements PropertiableHeadings {
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("M/d/yyyy");
    private final Provider<IconManager> iconManager;

    @Inject
    public PropertiableHeadingsImpl(Provider<IconManager> iconManager) {
        this.iconManager = iconManager;
    }

    @Override
    public String getHeading(PropertiableFile propertiable) {
        Object property = propertiable.getProperty(FilePropertyKey.NAME);
        String name = property == null ? "" : property.toString();
        String renderName = "";
        switch (propertiable.getCategory()) {
            case AUDIO: {
                String artist = propertiable.getPropertyString(FilePropertyKey.AUTHOR);
                String title = propertiable.getPropertyString(FilePropertyKey.TITLE);
                if (!StringUtils.isEmpty(artist) && !StringUtils.isEmpty(title)) {
                    renderName = artist + " - " + title;
                    break;
                }
                renderName = name;
                break;
            }
            default: {
                renderName = name + "." + this.getFileExtension(propertiable);
            }
        }
        return renderName.trim();
    }

    private String getFileExtension(PropertiableFile propertiableFile) {
        return FileUtils.getFileExtension(propertiableFile.getFileName());
    }

    @Override
    public String getSubHeading(PropertiableFile propertiable) {
        String subheading = "";
        switch (propertiable.getCategory()) {
            case AUDIO: {
                String albumTitle = propertiable.getPropertyString(FilePropertyKey.ALBUM);
                Long qualityScore = (Long)propertiable.getProperty(FilePropertyKey.QUALITY);
                Long length = (Long)propertiable.getProperty(FilePropertyKey.LENGTH);
                boolean insertHyphen = false;
                if (!StringUtils.isEmpty(albumTitle)) {
                    subheading = subheading + albumTitle;
                    insertHyphen = true;
                }
                if (qualityScore != null) {
                    if (insertHyphen) {
                        subheading = subheading + " - ";
                    }
                    subheading = subheading + GuiUtils.toQualityString(qualityScore);
                    Long bitRate = (Long)propertiable.getProperty(FilePropertyKey.BITRATE);
                    if (bitRate != null) {
                        subheading = subheading + " (" + bitRate + ")";
                    }
                    insertHyphen = true;
                }
                if (length != null) {
                    subheading = this.addLength(subheading, length, insertHyphen);
                    break;
                }
                Long fileSize = (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
                subheading = this.addFileSize(subheading, fileSize, insertHyphen);
                break;
            }
            case VIDEO: {
                Long qualityScore = (Long)propertiable.getProperty(FilePropertyKey.QUALITY);
                Long length = (Long)propertiable.getProperty(FilePropertyKey.LENGTH);
                Long fileSize = (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
                boolean insertHyphen = false;
                if (qualityScore != null) {
                    subheading = subheading + GuiUtils.toQualityString(qualityScore);
                    insertHyphen = true;
                }
                subheading = this.addLength(subheading, length, insertHyphen);
                subheading = this.addFileSize(subheading, fileSize, insertHyphen);
                break;
            }
            case IMAGE: {
                Long fileSize = (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
                boolean insertHyphen = false;
                Object time = propertiable.getProperty(FilePropertyKey.DATE_CREATED);
                if (time != null && time instanceof Long) {
                    subheading = this.DATE_FORMAT.format(new Date((Long)time));
                    insertHyphen = true;
                }
                subheading = this.addFileSize(subheading, fileSize, insertHyphen);
                break;
            }
            case PROGRAM: {
                subheading = this.getFileSize(propertiable);
                break;
            }
            default: {
                subheading = this.iconManager.get().getMIMEDescription(propertiable);
                subheading = subheading == null ? "" : subheading;
                Long fileSize = (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
                subheading = this.addFileSize(subheading, fileSize, !"".equals(subheading));
            }
        }
        return subheading == null ? "" : subheading;
    }

    private String addLength(String subheading, Long length, boolean insertHyphen) {
        if (length != null) {
            if (insertHyphen) {
                subheading = subheading + " - ";
            }
            subheading = subheading + CommonUtils.seconds2time(length);
        }
        return subheading;
    }

    private String addFileSize(String subheading, Long fileSize, boolean insertHyphen) {
        if (fileSize != null) {
            if (insertHyphen) {
                subheading = subheading + " - ";
            }
            subheading = subheading + GuiUtils.formatUnitFromBytes(fileSize);
        }
        return subheading;
    }

    @Override
    public String getFileSize(PropertiableFile propertiable) {
        Long fileSize = (Long)propertiable.getProperty(FilePropertyKey.FILE_SIZE);
        if (fileSize != null) {
            return GuiUtils.formatUnitFromBytes(fileSize) + "  (" + GuiUtils.formatBytes(fileSize) + ")";
        }
        return "";
    }
}

