/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.OSUtils;

public class WindowsFolderChooser {
    private static final int BIF_RETURNONLYFSDIRS = 1;
    private static final int BIF_EDITBOX = 16;
    private static final int BIF_NEWDIALOGSTYLE = 64;
    private static final int BFFM_INITIALIZED = 1;
    private static final int BFFM_SETSELECTION = 1127;
    private Shell32 shell32;
    private Shell32.BROWSEINFO info;

    public WindowsFolderChooser(Component component, String msg, boolean showEditBox, boolean allowNewFolder, final String currentDirectory) {
        BrowseInfoCallback proc = new BrowseInfoCallback(){

            @Override
            public int callback(Pointer wnd, int msg, int param, int lpData) {
                if (msg == 1 && currentDirectory != null) {
                    User32.INSTANCE.PostMessage(wnd, 1127, 1, currentDirectory);
                }
                return 0;
            }
        };
        this.shell32 = Shell32.INSTANCE;
        int flags = showEditBox ? 16 : 0;
        flags |= allowNewFolder ? 64 : 0;
        this.info = new Shell32.BROWSEINFO();
        this.info.lpszTitle = msg;
        this.info.hwndOwner = Native.getComponentPointer(component);
        this.info.lpfn = proc;
        this.info.ulFlags = flags |= 1;
    }

    public String showWidget() {
        String returnPath = (String)Worker.post(new Job(){

            @Override
            public Object run() {
                byte[] path = new byte[OSUtils.getMaxPathLength()];
                Pointer ptr = WindowsFolderChooser.this.shell32.SHBrowseForFolder(WindowsFolderChooser.this.info);
                WindowsFolderChooser.this.shell32.SHGetPathFromIDList(ptr, path);
                String returnPath = Native.toString(path);
                Ole32.INSTANCE.CoTaskMemFree(ptr);
                return returnPath;
            }
        });
        return returnPath;
    }

    private static interface BrowseInfoCallback
    extends StdCallLibrary.StdCallCallback {
        public int callback(Pointer var1, int var2, int var3, int var4);
    }

    private static interface User32
    extends StdCallLibrary {
        public static final Map UNICODE_OPTIONS = new HashMap(){
            {
                this.put("type-mapper", W32APITypeMapper.UNICODE);
                this.put("function-mapper", W32APIFunctionMapper.UNICODE);
            }
        };
        public static final Map ASCII_OPTIONS = new HashMap(){
            {
                this.put("type-mapper", W32APITypeMapper.ASCII);
                this.put("function-mapper", W32APIFunctionMapper.ASCII);
            }
        };
        public static final Map DEFAULT_OPTIONS = Boolean.getBoolean("w32.ascii") ? ASCII_OPTIONS : UNICODE_OPTIONS;
        public static final User32 INSTANCE = (User32)Native.loadLibrary("user32", User32.class, DEFAULT_OPTIONS);

        public void PostMessage(Pointer var1, int var2, int var3, String var4);
    }

    private static interface Ole32
    extends Library {
        public static final Ole32 INSTANCE = (Ole32)Native.loadLibrary("ole32", Ole32.class);

        public void CoTaskMemFree(Pointer var1);
    }

    private static interface Shell32
    extends Library {
        public static final Shell32 INSTANCE = (Shell32)Native.loadLibrary("shell32", Shell32.class);

        public Pointer SHBrowseForFolder(BROWSEINFO var1);

        public Boolean SHGetPathFromIDList(Pointer var1, byte[] var2);

        public static class BROWSEINFO
        extends Structure {
            public Pointer hwndOwner;
            public Pointer pidlRoot;
            public Pointer pszDisplayName;
            public String lpszTitle;
            public int ulFlags;
            public BrowseInfoCallback lpfn;
            public Pointer lParam;
            public int iImage;
        }
    }
}

