/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Map;

public class NameValue<V>
implements Map.Entry<String, V> {
    private final String _name;
    private V _value;

    public NameValue(String name) {
        this(name, null);
    }

    public NameValue(String name, V value) {
        this._name = name;
        this._value = value;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getKey() {
        return this._name;
    }

    @Override
    public V getValue() {
        return this._value;
    }

    @Override
    public V setValue(V value) {
        V old = this._value;
        this._value = value;
        return old;
    }

    public String toString() {
        return "name=" + this._name + ", value=" + this._value;
    }

    public static class ComparableByName<V>
    extends NameValue<V>
    implements Comparable<ComparableByName> {
        public ComparableByName(String name) {
            super(name);
        }

        public ComparableByName(String name, V value) {
            super(name, value);
        }

        @Override
        public int compareTo(ComparableByName b) {
            if (b == null) {
                return 1;
            }
            String nameB = b.getName();
            String name = this.getName();
            if (name == null && nameB == null) {
                return 0;
            }
            if (name == null) {
                return -1;
            }
            if (nameB == null) {
                return 1;
            }
            return name.compareTo(nameB);
        }
    }
}

