/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import java.io.IOException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.limewire.friend.api.FriendConnectionConfiguration;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.xmpp.client.impl.ConnectionConfigurationFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public class DNSConnectionConfigurationFactory
implements ConnectionConfigurationFactory {
    private static final Log LOG = LogFactory.getLog(DNSConnectionConfigurationFactory.class);
    private static final int MAX_XMPP_HOST_LOOKUPS = 3;

    @Override
    public boolean hasMore(FriendConnectionConfiguration connectionConfiguration, ConnectionConfigurationFactory.RequestContext requestContext) {
        return requestContext.getNumRequests() < 3;
    }

    @Override
    public ConnectionConfiguration getConnectionConfiguration(FriendConnectionConfiguration configuration, ConnectionConfigurationFactory.RequestContext requestContext) {
        return this.getConnectionConfig(configuration, requestContext);
    }

    private ConnectionConfiguration getConnectionConfig(FriendConnectionConfiguration configuration, ConnectionConfigurationFactory.RequestContext requestContext) {
        this.checkHasMore(configuration, requestContext);
        HostAndPort hostAndPort = new HostAndPort(configuration.getServiceName(), 5222);
        String serviceName = configuration.getServiceName();
        try {
            String domain = "_xmpp-client._tcp." + serviceName;
            Lookup lookup2 = new Lookup(domain, 33);
            Record[] answers = lookup2.run();
            int result = lookup2.getResult();
            if (result == 0) {
                hostAndPort = DNSConnectionConfigurationFactory.readHostAndPortFromDNSEntry(hostAndPort, domain, answers);
            } else if (result == 3) {
                LOG.debugf("dns lookup of {0} failed: host not found", (Object)domain);
            } else if (result == 1) {
                LOG.debugf("dns lookup of {0} failed: unrecoverable", (Object)domain);
            } else if (result == 4) {
                LOG.debugf("dns lookup of {0} failed: type not found", (Object)domain);
            } else if (result == 2) {
                LOG.debugf("dns lookup of {0} failed: try again", (Object)domain);
                requestContext.incrementRequests();
                if (this.hasMore(configuration, requestContext)) {
                    return this.getConnectionConfig(configuration, requestContext);
                }
            }
        }
        catch (IOException iox) {
            LOG.debug("Failed to look up SRV record", iox);
        }
        return new ConnectionConfiguration(hostAndPort.getHost(), hostAndPort.getPort(), serviceName);
    }

    private static HostAndPort readHostAndPortFromDNSEntry(HostAndPort fallback, String domain, Record[] answers) {
        HostAndPort hostAndPort = fallback;
        if (answers != null && answers.length > 0) {
            int lowestPriority = Integer.MAX_VALUE;
            int highestWeight = Integer.MIN_VALUE;
            for (Record rec : answers) {
                if (rec instanceof SRVRecord) {
                    SRVRecord srvRec = (SRVRecord)rec;
                    int priority = srvRec.getPriority();
                    int weight = srvRec.getWeight();
                    if (priority >= lowestPriority || weight <= highestWeight) continue;
                    hostAndPort = new HostAndPort(srvRec.getTarget().toString(), srvRec.getPort());
                    lowestPriority = priority;
                    highestWeight = weight;
                    continue;
                }
                LOG.debugf("dns lookup of {0} was successful, but contains non-SRV record: {1}: {2}", (Object)domain, (Object)rec.getClass().getSimpleName(), (Object)rec.toString());
            }
        } else {
            LOG.debugf("dns lookup of {0} was successful, but contained no records", (Object)domain);
        }
        return hostAndPort;
    }

    private void checkHasMore(FriendConnectionConfiguration connectionConfiguration, ConnectionConfigurationFactory.RequestContext requestContext) {
        if (!this.hasMore(connectionConfiguration, requestContext)) {
            throw new IllegalArgumentException("no more ConnectionConfigurations");
        }
    }

    private static class HostAndPort {
        private final String host;
        private final int port;

        public HostAndPort(String host, int defaultPort) {
            int colonIdx = host.indexOf(58);
            if (colonIdx == -1) {
                this.host = host;
                this.port = defaultPort;
            } else {
                this.host = host.substring(0, colonIdx);
                int p = -1;
                if (colonIdx < host.length() - 1) {
                    String portS = host.substring(colonIdx + 1);
                    try {
                        p = Integer.parseInt(portS);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                this.port = p > 0 ? p : defaultPort;
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

