/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaPanel;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.mt;
import org.mozilla.interfaces.nsICacheService;
import org.mozilla.interfaces.nsICookieManager;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.interfaces.nsIDocShell;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsISimpleEnumerator;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWindowWatcher;

public class MozillaConfig {
    static Log log = LogFactory.getLog(MozillaConfig.class);
    private static File xulRunnerHome;
    private static boolean initializeWithProfile;
    private static File profileDir;
    private static boolean isEnabledImages;
    private static boolean isEnabledJavascript;

    public static void setXULRunnerHome(File xulDir) {
        xulRunnerHome = xulDir;
    }

    public static File getXULRunnerHome() {
        return xulRunnerHome;
    }

    public static boolean isInitializeWithProfile() {
        return initializeWithProfile;
    }

    public static void setInitializeWithProfile(boolean profileOn) {
        initializeWithProfile = profileOn;
    }

    public static void setProfileDir(File profileDir) {
        MozillaConfig.profileDir = profileDir;
    }

    public static File getProfileDir() {
        return profileDir;
    }

    public static void enableImages() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                isEnabledImages = true;
                MozillaConfig.applyForAllWindows(new DocShellApplyTask(){

                    public void apply(nsIDocShell ds) {
                        ds.setAllowImages(true);
                    }
                });
            }
        });
    }

    public static void disableImages() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                isEnabledImages = false;
                MozillaConfig.applyForAllWindows(new DocShellApplyTask(){

                    public void apply(nsIDocShell ds) {
                        ds.setAllowImages(false);
                    }
                });
            }
        });
    }

    public static void enableImages(final MozillaPanel moz) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
                nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
                docShell.setAllowImages(false);
            }
        });
    }

    public static void disableImages(final MozillaPanel moz) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
                nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
                docShell.setAllowImages(false);
            }
        });
    }

    public static boolean isEnabledImages() {
        return isEnabledImages;
    }

    public static void enableJavascript() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                isEnabledJavascript = true;
                MozillaConfig.applyForAllWindows(new DocShellApplyTask(){

                    public void apply(nsIDocShell ds) {
                        ds.setAllowJavascript(true);
                    }
                });
            }
        });
    }

    public static void disableJavascript() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                isEnabledJavascript = false;
                MozillaConfig.applyForAllWindows(new DocShellApplyTask(){

                    public void apply(nsIDocShell ds) {
                        ds.setAllowJavascript(false);
                    }
                });
            }
        });
    }

    public static void enableJavascript(final MozillaPanel moz) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
                nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
                docShell.setAllowJavascript(false);
            }
        });
    }

    public static void disableJavascript(final MozillaPanel moz) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = moz.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
                nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
                docShell.setAllowJavascript(false);
            }
        });
    }

    public static boolean isEnabledJavascript() {
        return isEnabledJavascript;
    }

    private static void applyForAllWindows(DocShellApplyTask t) {
        assert (MozillaExecutor.isMozillaThread());
        nsIWindowWatcher ww = XPCOMUtils.getService("@mozilla.org/embedcomp/window-watcher;1", nsIWindowWatcher.class);
        nsISimpleEnumerator winEn = ww.getWindowEnumerator();
        while (winEn.hasMoreElements()) {
            nsIDOMWindowInternal domWin = XPCOMUtils.qi(winEn.getNext(), nsIDOMWindowInternal.class);
            nsIWebBrowserChrome chrome = ww.getChromeForWindow(domWin);
            nsIWebBrowser webBrowser = chrome.getWebBrowser();
            nsIInterfaceRequestor ir = XPCOMUtils.qi(webBrowser, nsIInterfaceRequestor.class);
            nsIDocShell docShell = (nsIDocShell)ir.getInterface("{7d1cf6b9-daa3-476d-8f9f-9eb2a971a95c}");
            t.apply(docShell);
        }
    }

    public static void setManualProxy(final String httpHost, final int httpPort, final String sslHost, final int sslPort, final String ftpHost, final int ftpPort, final String socksHost, final int socksPort, final String noProxyFor) {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                nsIPrefBranch pref = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefBranch.class);
                pref.setIntPref("network.proxy.type", 1);
                boolean validConfig = false;
                if (httpHost != null && httpHost.length() > 0 && httpPort > 0) {
                    pref.setCharPref("network.proxy.http", httpHost);
                    pref.setIntPref("network.proxy.http_port", httpPort);
                    validConfig = true;
                } else {
                    pref.setCharPref("network.proxy.http", "");
                    pref.setIntPref("network.proxy.http_port", 0);
                }
                if (sslHost != null && sslHost.length() > 0 && sslPort > 0) {
                    pref.setCharPref("network.proxy.ssl", sslHost);
                    pref.setIntPref("network.proxy.ssl_port", sslPort);
                    validConfig = true;
                } else {
                    pref.setCharPref("network.proxy.ssl", "");
                    pref.setIntPref("network.proxy.ssl_port", 0);
                }
                if (ftpHost != null && ftpHost.length() > 0 && ftpPort > 0) {
                    pref.setCharPref("network.proxy.ftp", ftpHost);
                    pref.setIntPref("network.proxy.ftp_port", ftpPort);
                    validConfig = true;
                } else {
                    pref.setCharPref("network.proxy.ftp", "");
                    pref.setIntPref("network.proxy.ftp_port", 0);
                }
                if (socksHost != null && socksHost.length() > 0 && socksPort > 0) {
                    pref.setCharPref("network.proxy.socks", socksHost);
                    pref.setIntPref("network.proxy.socks_port", socksPort);
                    validConfig = true;
                } else {
                    pref.setCharPref("network.proxy.socks", "");
                    pref.setIntPref("network.proxy.socks_port", 0);
                }
                if (noProxyFor != null && noProxyFor.length() > 0) {
                    pref.setCharPref("network.proxy.no_proxies_on", noProxyFor);
                } else {
                    pref.setCharPref("network.proxy.no_proxies_on", "localhost, 127.0.0.1");
                }
                if (!validConfig) {
                    pref.setIntPref("network.proxy.type", 0);
                }
            }
        });
    }

    public static void setAutomaticProxy(final String configURL) {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                nsIPrefBranch pref = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefBranch.class);
                pref.setIntPref("network.proxy.type", 2);
                boolean validConfig = false;
                if (configURL != null && configURL.length() > 0) {
                    pref.setCharPref("network.proxy.autoconfig_url", configURL);
                    validConfig = true;
                } else {
                    pref.setCharPref("network.proxy.autoconfig_url", "");
                }
                if (!validConfig) {
                    pref.setIntPref("network.proxy.type", 0);
                }
            }
        });
    }

    public static void disableProxy() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                nsIPrefBranch pref = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefBranch.class);
                pref.setIntPref("network.proxy.type", 0);
            }
        });
    }

    public static void cleanCache() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                nsICacheService cache = XPCOMUtils.getService("@mozilla.org/network/cache-service;1", nsICacheService.class);
                cache.evictEntries(0);
            }
        });
    }

    public static void cleanCookies() {
        MozillaExecutor.mozPostponableSyncExec(new Runnable(){

            public void run() {
                nsICookieManager cookieManager = XPCOMUtils.getService("@mozilla.org/cookiemanager;1", nsICookieManager.class);
                cookieManager.removeAll();
            }
        });
    }

    public static String getConfigSummary() {
        String s = "";
        File xulDir = MozillaConfig.getXULRunnerHome();
        s = s + String.format(mt.t("MozillaConfig.XULRunnerHome"), xulDir != null ? xulDir.getAbsolutePath() : mt.t("MozillaConfig.not_resolved"));
        File profDir = MozillaConfig.getProfileDir();
        s = s + String.format(mt.t("MozillaConfig.Profile_directory"), profDir != null ? profDir.getAbsolutePath() : mt.t("MozillaConfig.not_used"));
        s = s + String.format(mt.t("MozillaConfig.Platform"), new Object[]{Platform.platform});
        s = s + String.format(mt.t("MozillaConfig.Java"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor"));
        return s;
    }

    private static int parseInt(String s) {
        if (s.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        initializeWithProfile = true;
        isEnabledImages = true;
        isEnabledJavascript = true;
        String httpHost = System.getProperty("proxy.http.host", "");
        int httpPort = MozillaConfig.parseInt(System.getProperty("proxy.http.port", ""));
        String sslHost = System.getProperty("proxy.https.host", "");
        int sslPort = MozillaConfig.parseInt(System.getProperty("proxy.https.port", ""));
        String ftpHost = System.getProperty("proxy.https.host", "");
        int ftpPort = MozillaConfig.parseInt(System.getProperty("proxy.https.port", ""));
        String socksHost = System.getProperty("proxy.https.host", "");
        int socksPort = MozillaConfig.parseInt(System.getProperty("proxy.https.port", ""));
        String noProxyFor = System.getProperty("proxy.bypass.list", "");
        MozillaConfig.setManualProxy(httpHost, httpPort, sslHost, sslPort, ftpHost, ftpPort, socksHost, socksPort, noProxyFor);
    }

    private static interface DocShellApplyTask {
        public void apply(nsIDocShell var1);
    }
}

