import wx
import wx.calendar

class ETMCal(wx.Dialog):
    def __init__(self):
        wx.Dialog.__init__(self, None, -1, 'etm', size=(225,225))
        selecteddate = wx.DateTime_Now()
        cal = wx.calendar.CalendarCtrl(self, -1, date=selecteddate,
                size = (-1, -1),
                style = wx.calendar.CAL_SHOW_HOLIDAYS
                    | wx.calendar.CAL_SUNDAY_FIRST
                    | wx.calendar.CAL_SHOW_SURROUNDING_WEEKS
                    )
        self.cal = cal
        self.selecteddate = selecteddate.Format("%Y-%m-%d")
        self.Bind(wx.calendar.EVT_CALENDAR_SEL_CHANGED, 
                self.OnCalSelChanged, id=cal.GetId())
        self.Bind(wx.calendar.EVT_CALENDAR, self.OnCalSelected, 
                id=cal.GetId())
        self.cal.Bind(wx.EVT_CHAR, self.OnChar)
        ok = wx.Button(self, wx.ID_OK, "OK")
        ok.SetDefault()
        cancel = wx.Button(self, wx.ID_CANCEL, "CANCEL")
        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(cal, 0, wx.EXPAND | wx.ALL, 5)
        hbox = wx.BoxSizer(wx.HORIZONTAL)
        hbox.Add(cancel, 1, wx.ALIGN_RIGHT | wx.ALL, 5)
        hbox.Add(ok, 1, wx.ALIGN_RIGHT | wx.ALL, 5)
        vbox.Add(hbox, 0, wx.ALIGN_RIGHT)
        self.SetSizerAndFit(vbox)
        self.Layout()

    def OnCalSelChanged(self, event):
        self.selecteddate = event.GetDate().Format("%Y-%m-%d")

    def OnCalSelected(self, event):
        self.selecteddate = event.GetDate().Format("%Y-%m-%d")
        self.OnQuit(event)

    def OnQuit(self, event):
        self.Close()
        self.SetReturnCode(wx.ID_OK)

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        if keycode == 13:         # enter
            self.OnQuit(event)
        else:
            event.Skip()

def main():
    app = wx.App()
    dialog = ETMCal()
    result = dialog.ShowModal()
    if result == wx.ID_OK and dialog.selecteddate:
        return dialog.selecteddate
    else:
        return result

if __name__ == "__main__":
    res = main()
    print(res)