/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.filter.DefaultFilter;
import freemind.controller.filter.Filter;
import freemind.controller.filter.condition.NoFilteringCondition;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MapRegistry;
import freemind.modes.MindMap;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public abstract class MapAdapter
extends DefaultTreeModel
implements MindMap {
    private EventListenerList treeModelListeners = new EventListenerList();
    protected int changesPerformedSinceLastSave = 0;
    protected boolean readOnly = true;
    private File file;
    private FreeMindMain frame;
    protected static Logger logger;
    private MapRegistry registry;
    private Filter filter = null;
    protected final ModeController mModeController;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    public MapAdapter(FreeMindMain frame, ModeController modeController) {
        super(null);
        this.frame = frame;
        this.mModeController = modeController;
        this.mModeController.setModel(this);
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        this.registry = new MapRegistry(this, modeController);
        this.filter = new DefaultFilter(NoFilteringCondition.createCondition(), true, false);
    }

    public ModeController getModeController() {
        return this.mModeController;
    }

    public abstract boolean save(File var1);

    public abstract void load(URL var1) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException;

    public void load(File file) throws FileNotFoundException, IOException {
        try {
            this.load(Tools.fileToUrl(file));
        }
        catch (XMLParseException e) {
            Resources.getInstance().logException(e);
        }
        catch (URISyntaxException e) {
            Resources.getInstance().logException(e);
        }
    }

    public String tryToLock(File file) throws Exception {
        return null;
    }

    public void destroy() {
        this.removeNodes(this.getRootNode());
    }

    private void removeNodes(MindMapNode node) {
        while (node.getHooks().size() > 0) {
            PermanentNodeHook hook = (PermanentNodeHook)node.getHooks().get(0);
            node.removeHook(hook);
        }
        this.mModeController.fireNodePreDeleteEvent(node);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.removeNodes(child);
        }
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public boolean isSaved() {
        return this.changesPerformedSinceLastSave == 0;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setSaved(boolean saved) {
        boolean setTitle = false;
        if (saved) {
            this.changesPerformedSinceLastSave = 0;
            setTitle = true;
        } else {
            if (this.changesPerformedSinceLastSave == 0) {
                setTitle = true;
            }
            ++this.changesPerformedSinceLastSave;
        }
        if (setTitle) {
            this.getModeController().getController().setTitle();
        }
    }

    protected int getNumberOfChangesSinceLastSave() {
        return this.changesPerformedSinceLastSave;
    }

    public MindMapNode getRootNode() {
        return (MindMapNode)this.getRoot();
    }

    public void setRoot(MindMapNode root) {
        super.setRoot(root);
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() throws MalformedURLException {
        return this.getFile() != null ? Tools.fileToUrl(this.getFile()) : null;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected String getText(String textId) {
        return this.getFrame().getResourceString(textId);
    }

    public String getAsPlainText(List mindMapNodes) {
        return "";
    }

    public String getAsRTF(List mindMapNodes) {
        return "";
    }

    public String getAsHTML(List mindMapNodes) {
        return null;
    }

    public String getRestoreable() {
        return null;
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return null;
    }

    public void nodeChanged(TreeNode node) {
        this.getModeController().nodeChanged((MindMapNode)node);
    }

    public void nodeRefresh(TreeNode node) {
        this.getModeController().nodeRefresh((MindMapNode)node);
    }

    void nodeChangedInternal(TreeNode node) {
        if (node != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        e = this.fireTreeNodesInserted(source, path, childIndices, children, listeners, e);
        MindMapNode node = (MindMapNode)path[path.length - 1];
        this.fireTreeNodesInserted(source, path, childIndices, children, node.getListeners().getListenerList(), e);
    }

    private TreeModelEvent fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children, Object[] listeners, TreeModelEvent e) {
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
        return e;
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        e = this.fireTreeNodesRemoved(source, path, childIndices, children, listeners, e);
        MindMapNode node = (MindMapNode)path[path.length - 1];
        this.fireTreeNodesRemoved(source, path, childIndices, children, node.getListeners().getListenerList(), e);
    }

    private TreeModelEvent fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children, Object[] listeners, TreeModelEvent e) {
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
        return e;
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        e = this.fireTreeStructureChanged(source, path, childIndices, children, listeners, e);
        MindMapNode node = (MindMapNode)path[path.length - 1];
        this.fireTreeStructureChanged(source, path, childIndices, children, node.getListeners().getListenerList(), e);
    }

    private TreeModelEvent fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children, Object[] listeners, TreeModelEvent e) {
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
        return e;
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        e = this.fireTreeNodesChanged(source, path, childIndices, children, listeners, e);
        MindMapNode node = (MindMapNode)path[path.length - 1];
        this.fireTreeNodesChanged(source, path, childIndices, children, node.getListeners().getListenerList(), e);
    }

    private TreeModelEvent fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children, Object[] listeners, TreeModelEvent e) {
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TreeModelListener == null ? MapAdapter.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
        return e;
    }

    public MapRegistry getRegistry() {
        return this.registry;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

