/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.common.TextTranslator;
import freemind.controller.BlindIcon;
import freemind.controller.actions.generated.instance.ScriptEditorWindowConfigurationStorage;
import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import plugins.script.ScriptingEngine;
import plugins.script.SignedScriptHandler;

public class ScriptEditorPanel
extends JDialog {
    private static final long serialVersionUID = 3221975191441136520L;
    private static final String WINDOW_PREFERENCE_STORAGE_PROPERTY = "plugins.script.ScriptEditorPanel/window_positions";
    private final FreeMindMain mFrame;
    private final ScriptModel mScriptModel;
    private JList mScriptList;
    private JTextArea mScriptTextField;
    private DefaultListModel mListModel;
    private Integer mLastSelected = null;
    private JTextArea mScriptResultField;
    private JSplitPane mCentralUpperPanel;
    private JSplitPane mCentralPanel;
    private Logger logger;
    private JLabel mStatus;
    private AbstractAction mRunAction;
    private SignAction mSignAction;

    public ScriptEditorPanel(ScriptModel pScriptModel, FreeMindMain pFrame, boolean pHasNewScriptFunctionality) {
        super((Frame)pFrame.getJFrame(), true);
        this.logger = pFrame.getLogger(this.getClass().getName());
        this.mScriptModel = pScriptModel;
        this.mFrame = pFrame;
        this.setTitle(pFrame.getResourceString("plugins/ScriptEditor/window.title"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ScriptEditorPanel.this.disposeDialog(true);
            }
        });
        Tools.addEscapeActionToDialog((JDialog)this, (Action)new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                ScriptEditorPanel.this.disposeDialog(true);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mListModel = new DefaultListModel();
        this.mScriptList = new JList(this.mListModel);
        this.mScriptList.setSelectionMode(0);
        this.mScriptList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent pEvent) {
                if (pEvent.getValueIsAdjusting()) {
                    return;
                }
                ScriptEditorPanel.this.select(ScriptEditorPanel.this.mScriptList.getSelectedIndex());
            }
        });
        this.mScriptTextField = new JTextArea();
        this.mScriptTextField.setFont(new Font("Monospaced", 0, 12));
        this.mScriptTextField.setEnabled(false);
        this.mScriptTextField.setTabSize(2);
        this.mCentralUpperPanel = new JSplitPane(1, this.mScriptList, new JScrollPane(this.mScriptTextField));
        this.mCentralUpperPanel.setContinuousLayout(true);
        this.mScriptResultField = new JTextArea();
        this.mScriptResultField.setEditable(false);
        this.mScriptResultField.setWrapStyleWord(true);
        this.mCentralPanel = new JSplitPane(0, this.mCentralUpperPanel, new JScrollPane(this.mScriptResultField));
        this.mCentralPanel.setDividerLocation(0.8);
        this.mCentralPanel.setContinuousLayout(true);
        contentPane.add((Component)this.mCentralPanel, "Center");
        this.mStatus = new JLabel();
        contentPane.add((Component)this.mStatus, "South");
        this.mScriptTextField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                int caretPosition = ScriptEditorPanel.this.mScriptTextField.getCaretPosition();
                try {
                    int lineOfOffset = ScriptEditorPanel.this.mScriptTextField.getLineOfOffset(caretPosition);
                    ScriptEditorPanel.this.mStatus.setText("Line: " + (lineOfOffset + 1) + ", Column: " + (caretPosition - ScriptEditorPanel.this.mScriptTextField.getLineStartOffset(lineOfOffset) + 1));
                }
                catch (BadLocationException e) {
                    Resources.getInstance().logException((Throwable)e);
                }
            }
        });
        this.updateFields();
        this.mScriptTextField.repaint();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu();
        Tools.setLabelAndMnemonic((AbstractButton)menu, (String)pFrame.getResourceString("plugins/ScriptEditor.menu_actions"));
        if (pHasNewScriptFunctionality) {
            this.addAction(menu, new NewScriptAction(pFrame.getResourceString("plugins/ScriptEditor.new_script")));
        }
        this.mRunAction = new RunAction(pFrame.getResourceString("plugins/ScriptEditor.run"));
        this.mRunAction.setEnabled(false);
        this.addAction(menu, this.mRunAction);
        this.mSignAction = new SignAction(pFrame.getResourceString("plugins/ScriptEditor.sign"));
        this.mSignAction.setEnabled(false);
        this.addAction(menu, this.mSignAction);
        CancelAction cancelAction = new CancelAction(pFrame.getResourceString("plugins/ScriptEditor.cancel"));
        this.addAction(menu, cancelAction);
        ExitAction exitAction = new ExitAction(pFrame.getResourceString("plugins/ScriptEditor.exit"));
        this.addAction(menu, exitAction);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        ScriptEditorWindowConfigurationStorage storage = this.mScriptModel.decorateDialog(this, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        if (storage != null) {
            this.mCentralUpperPanel.setDividerLocation(storage.getLeftRatio());
            this.mCentralPanel.setDividerLocation(storage.getTopRatio());
        } else {
            this.mCentralUpperPanel.setDividerLocation(100);
            this.mCentralPanel.setDividerLocation(240);
        }
    }

    private void addAction(JMenu menu, AbstractAction action) {
        JMenuItem item = menu.add(action);
        Tools.setLabelAndMnemonic((AbstractButton)item, (String)((String)action.getValue("Name")));
        item.setIcon((Icon)new BlindIcon(16));
    }

    private void updateFields() {
        this.mListModel.clear();
        for (int i = 0; i < this.mScriptModel.getAmountOfScripts(); ++i) {
            ScriptHolder script = this.mScriptModel.getScript(i);
            this.mListModel.addElement(script.getScriptName());
        }
    }

    private void select(int pIndex) {
        this.mScriptTextField.setEnabled(pIndex >= 0);
        this.mRunAction.setEnabled(pIndex >= 0);
        this.mSignAction.setEnabled(pIndex >= 0);
        if (pIndex < 0) {
            this.mScriptTextField.setText("");
            return;
        }
        this.storeCurrent();
        this.mScriptTextField.setText(this.mScriptModel.getScript(pIndex).getScript());
        this.mLastSelected = new Integer(pIndex);
        if (pIndex >= 0 && this.mScriptList.getSelectedIndex() != pIndex) {
            this.mScriptList.setSelectedIndex(pIndex);
        }
    }

    private void storeCurrent() {
        if (this.mLastSelected != null) {
            int oldIndex = this.mLastSelected;
            this.mScriptModel.setScript(oldIndex, this.mScriptModel.getScript(oldIndex).setScript(this.mScriptTextField.getText()));
        }
    }

    private void disposeDialog(boolean pIsCanceled) {
        int action;
        if (!this.mScriptList.isSelectionEmpty()) {
            this.select(this.mScriptList.getSelectedIndex());
        }
        if (pIsCanceled && this.mScriptModel.isDirty() && (action = JOptionPane.showConfirmDialog(this, this.mFrame.getResourceString("ScriptEditorPanel.changed_cancel"), "FreeMind", 2)) == 2) {
            return;
        }
        ScriptEditorWindowConfigurationStorage storage = new ScriptEditorWindowConfigurationStorage();
        storage.setLeftRatio(this.mCentralUpperPanel.getDividerLocation());
        storage.setTopRatio(this.mCentralPanel.getDividerLocation());
        this.mScriptModel.storeDialogPositions(this, storage, WINDOW_PREFERENCE_STORAGE_PROPERTY);
        this.setVisible(false);
        this.dispose();
        this.mScriptModel.endDialog(pIsCanceled);
    }

    PrintStream getPrintStream() {
        return new PrintStream(new ResultFieldStream());
    }

    ScriptingEngine.ErrorHandler getErrorHandler() {
        return new ScriptingEngine.ErrorHandler(){

            public void gotoLine(int pLineNumber) {
                Element element3;
                Element element4;
                ScriptEditorPanel.this.logger.info("Line number: " + pLineNumber);
                if (pLineNumber > 0 && pLineNumber <= ScriptEditorPanel.this.mScriptTextField.getLineCount() && (element4 = (element3 = ScriptEditorPanel.this.mScriptTextField.getDocument().getDefaultRootElement()).getElement(pLineNumber - 1)) != null) {
                    ScriptEditorPanel.this.mScriptTextField.select(element4.getStartOffset(), element4.getEndOffset());
                }
            }
        };
    }

    public static interface ScriptModel {
        public int getAmountOfScripts();

        public ScriptHolder getScript(int var1);

        public void setScript(int var1, ScriptHolder var2);

        public boolean executeScript(int var1, PrintStream var2, ScriptingEngine.ErrorHandler var3);

        public void storeDialogPositions(ScriptEditorPanel var1, ScriptEditorWindowConfigurationStorage var2, String var3);

        public ScriptEditorWindowConfigurationStorage decorateDialog(ScriptEditorPanel var1, String var2);

        public void endDialog(boolean var1);

        public boolean isDirty();

        public int addNewScript();
    }

    public static class ScriptHolder {
        String mScript;
        String mScriptName;

        public ScriptHolder(String pScriptName, String pScript) {
            this.mScript = pScript;
            this.mScriptName = pScriptName;
        }

        public String getScript() {
            return this.mScript;
        }

        public String getScriptName() {
            return this.mScriptName;
        }

        public ScriptHolder setScript(String pScript) {
            this.mScript = pScript;
            return this;
        }

        public ScriptHolder setScriptName(String pScriptName) {
            this.mScriptName = pScriptName;
            return this;
        }
    }

    private final class NewScriptAction
    extends AbstractAction {
        private NewScriptAction(String pArg0) {
            super(pArg0);
        }

        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            ScriptEditorPanel.this.mLastSelected = null;
            int scriptIndex = ScriptEditorPanel.this.mScriptModel.addNewScript();
            ScriptEditorPanel.this.updateFields();
            ScriptEditorPanel.this.select(scriptIndex);
        }
    }

    private final class ExitAction
    extends AbstractAction {
        private ExitAction(String pArg0) {
            super(pArg0);
        }

        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            ScriptEditorPanel.this.disposeDialog(false);
        }
    }

    private final class CancelAction
    extends AbstractAction {
        private CancelAction(String pArg0) {
            super(pArg0);
        }

        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.disposeDialog(true);
        }
    }

    private final class SignAction
    extends AbstractAction {
        private SignAction(String pArg0) {
            super(pArg0);
        }

        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            if (!ScriptEditorPanel.this.mScriptList.isSelectionEmpty()) {
                int selectedIndex = ScriptEditorPanel.this.mScriptList.getSelectedIndex();
                ScriptHolder script = ScriptEditorPanel.this.mScriptModel.getScript(selectedIndex);
                String signedScript = new SignedScriptHandler().signScript(script.mScript, (TextTranslator)Resources.getInstance(), ScriptEditorPanel.this.mFrame);
                script.setScript(signedScript);
                ScriptEditorPanel.this.mScriptModel.setScript(selectedIndex, script);
                ScriptEditorPanel.this.mScriptTextField.setText(signedScript);
            }
        }
    }

    private final class RunAction
    extends AbstractAction {
        private RunAction(String pArg0) {
            super(pArg0);
        }

        public void actionPerformed(ActionEvent arg0) {
            ScriptEditorPanel.this.storeCurrent();
            if (!ScriptEditorPanel.this.mScriptList.isSelectionEmpty()) {
                ScriptEditorPanel.this.mScriptResultField.setText("");
                ScriptEditorPanel.this.mScriptModel.executeScript(ScriptEditorPanel.this.mScriptList.getSelectedIndex(), ScriptEditorPanel.this.getPrintStream(), ScriptEditorPanel.this.getErrorHandler());
            }
        }
    }

    private final class ResultFieldStream
    extends OutputStream {
        private ResultFieldStream() {
        }

        public void write(int pByte) throws IOException {
            ScriptEditorPanel.this.mScriptResultField.append(new String(new byte[]{(byte)pByte}));
        }

        public void write(byte[] pB) throws IOException {
            ScriptEditorPanel.this.mScriptResultField.append(new String(pB));
        }
    }
}

