/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.common.TextTranslator;
import freemind.main.FreeMindMain;
import freemind.main.FreeMindSecurityManager;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import java.awt.Component;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import plugins.script.ScriptingRegistration;
import plugins.script.ScriptingSecurityManager;
import plugins.script.SignedScriptHandler;

public class ScriptingEngine
extends MindMapHookAdapter {
    public static final String SCRIPT_PREFIX = "script";
    private static final HashMap sScriptCookies = new HashMap();
    static Logger logger;

    public void startupMapHook() {
        super.startupMapHook();
        MindMapNode node = this.getMindMapController().getMap().getRootNode();
        Tools.BooleanHolder booleanHolder = new Tools.BooleanHolder(false);
        String scriptLocation = this.getResourceString("ScriptLocation");
        if (scriptLocation != null && scriptLocation.length() != 0) {
            this.performExternalScript(scriptLocation, node, booleanHolder);
            return;
        }
        this.performScriptOperation(node, booleanHolder);
    }

    private void performExternalScript(String pScriptLocation, MindMapNode pNode, Tools.BooleanHolder pBooleanHolder) {
        ScriptingRegistration reg = (ScriptingRegistration)this.getPluginBaseClass();
        String scriptContent = Tools.getFile((File)new File(pScriptLocation));
        if (scriptContent == null) {
            return;
        }
        ScriptingEngine.executeScript(pNode, pBooleanHolder, scriptContent, this.getMindMapController(), new ErrorHandler(){

            public void gotoLine(int pLineNumber) {
            }
        }, System.out, reg.getScriptCookies());
    }

    private void performScriptOperation(MindMapNode node, Tools.BooleanHolder pAlreadyAScriptExecuted) {
        this.getController().getFrame().setWaitingCursor(true);
        ListIterator iter = node.childrenUnfolded();
        while (iter.hasNext()) {
            MindMapNode element = (MindMapNode)iter.next();
            this.performScriptOperation(element, pAlreadyAScriptExecuted);
        }
        NodeAttributeTableModel attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        for (int row = 0; row < attributes.getRowCount(); ++row) {
            String attrKey = (String)attributes.getName(row);
            String script = (String)attributes.getValue(row);
            logger.info("Found key = " + attrKey);
            if (!attrKey.startsWith(SCRIPT_PREFIX)) continue;
            ScriptingRegistration reg = (ScriptingRegistration)this.getPluginBaseClass();
            boolean result = ScriptingEngine.executeScript(node, pAlreadyAScriptExecuted, script, this.getMindMapController(), new ErrorHandler(){

                public void gotoLine(int pLineNumber) {
                }
            }, System.out, reg.getScriptCookies());
            if (!result) break;
        }
        this.getController().getFrame().setWaitingCursor(false);
    }

    public static int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean executeScript(MindMapNode node, Tools.BooleanHolder pAlreadyAScriptExecuted, String script, MindMapController pMindMapController, ErrorHandler pErrorHandler, PrintStream pOutStream, HashMap pScriptCookies) {
        boolean isSigned;
        int showResult;
        FreeMindMain frame = pMindMapController.getFrame();
        if (!pAlreadyAScriptExecuted.getValue() && (showResult = new OptionalDontShowMeAgainDialog(frame.getJFrame(), (Component)pMindMapController.getSelectedView(), "really_execute_script", "confirmation", (TextTranslator)pMindMapController, (OptionalDontShowMeAgainDialog.DontShowPropertyHandler)new OptionalDontShowMeAgainDialog.StandardPropertyHandler(pMindMapController.getController(), "resources_execute_scripts_without_asking"), 0).show().getResult()) != 0) {
            return false;
        }
        pAlreadyAScriptExecuted.setValue(true);
        Binding binding = new Binding();
        binding.setVariable("c", (Object)pMindMapController);
        binding.setVariable("node", (Object)node);
        binding.setVariable("cookies", (Object)sScriptCookies);
        GroovyShell shell = new GroovyShell(binding);
        boolean assignResult = false;
        String assignTo = null;
        if (script.startsWith("=")) {
            script = script.substring(1);
            assignResult = true;
        } else {
            String start;
            int indexOfEquals = script.indexOf(61);
            if (indexOfEquals > 0 && (start = script.substring(0, indexOfEquals)).matches("[a-zA-Z0-9_]+")) {
                assignTo = start;
                script = script.substring(indexOfEquals + 1);
                assignResult = true;
            }
        }
        String executeWithoutAsking = frame.getProperty("resources_execute_scripts_without_asking");
        String executeWithoutFileRestriction = frame.getProperty("resources_execute_scripts_without_file_restriction");
        String executeWithoutNetworkRestriction = frame.getProperty("resources_execute_scripts_without_network_restriction");
        String executeWithoutExecRestriction = frame.getProperty("resources_execute_scripts_without_exec_restriction");
        String signedScriptsWithoutRestriction = frame.getProperty("resources_signed_script_are_trusted");
        PrintStream oldOut = System.out;
        Object value = null;
        GroovyRuntimeException e1 = null;
        Throwable e2 = null;
        boolean filePerm = Tools.isPreferenceTrue((String)executeWithoutFileRestriction);
        boolean networkPerm = Tools.isPreferenceTrue((String)executeWithoutNetworkRestriction);
        boolean execPerm = Tools.isPreferenceTrue((String)executeWithoutExecRestriction);
        if (Tools.isPreferenceTrue((String)signedScriptsWithoutRestriction) && (isSigned = new SignedScriptHandler().isScriptSigned(script, pOutStream))) {
            filePerm = true;
            networkPerm = true;
            execPerm = true;
        }
        ScriptingSecurityManager scriptingSecurityManager = new ScriptingSecurityManager(filePerm, networkPerm, execPerm);
        FreeMindSecurityManager securityManager = (FreeMindSecurityManager)System.getSecurityManager();
        try {
            System.setOut(pOutStream);
            securityManager.setFinalSecurityManager((SecurityManager)scriptingSecurityManager);
            value = shell.evaluate(script);
        }
        catch (GroovyRuntimeException e) {
            e1 = e;
        }
        catch (Throwable e) {
            e2 = e;
        }
        finally {
            securityManager.setFinalSecurityManager((SecurityManager)scriptingSecurityManager);
            System.setOut(oldOut);
            frame.setProperty("resources_execute_scripts_without_asking", executeWithoutAsking);
            frame.setProperty("resources_execute_scripts_without_file_restriction", executeWithoutFileRestriction);
            frame.setProperty("resources_execute_scripts_without_network_restriction", executeWithoutNetworkRestriction);
            frame.setProperty("resources_execute_scripts_without_exec_restriction", executeWithoutExecRestriction);
            frame.setProperty("resources_signed_script_are_trusted", signedScriptsWithoutRestriction);
        }
        if (e1 != null) {
            String resultString = e1.getMessage();
            pOutStream.print("message: " + resultString);
            ModuleNode module = e1.getModule();
            ASTNode astNode = e1.getNode();
            int lineNumber = -1;
            lineNumber = module != null ? module.getLineNumber() : (astNode != null ? astNode.getLineNumber() : ScriptingEngine.findLineNumberInString(resultString, lineNumber));
            pOutStream.print("Line number: " + lineNumber);
            pErrorHandler.gotoLine(lineNumber);
            return false;
        }
        if (e2 != null) {
            Resources.getInstance().logException(e2);
            pOutStream.print(e2.getMessage());
            String cause = e2.getCause() != null ? e2.getCause().getMessage() : "";
            String message = e2.getMessage() != null ? e2.getMessage() : "";
            pMindMapController.getController().errorMessage((Object)(e2.getClass().getName() + ": " + cause + (cause.length() != 0 && message.length() != 0 ? ", " : "") + message));
            return false;
        }
        pOutStream.print(frame.getResourceString("plugins/ScriptEditor/window.Result") + value);
        if (assignResult && value != null) {
            if (assignTo == null) {
                pMindMapController.setNodeText(node, value.toString());
            } else {
                pMindMapController.editAttribute(node, assignTo, value.toString());
            }
        }
        return true;
    }

    public static interface ErrorHandler {
        public void gotoLine(int var1);
    }
}

