/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.controller.BlindIcon;
import freemind.main.Resources;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ThreeCheckBoxProperty
extends PropertyBean
implements PropertyControl {
    protected String mFalseValue = "false";
    protected String mTrueValue = "true";
    protected String mDontTouchValue = "don_t_touch";
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";
    public static final String DON_T_TOUCH_VALUE = "don_t_touch";
    protected static final int DON_T_TOUCH_VALUE_INT = 2;
    protected static final int TRUE_VALUE_INT = 0;
    protected static final int FALSE_VALUE_INT = 1;
    private static final ImageIcon PLUS_IMAGE = new ImageIcon(Resources.getInstance().getResource("images/edit_add.png"));
    private static final ImageIcon MINUS_IMAGE = new ImageIcon(Resources.getInstance().getResource("images/edit_remove.png"));
    private static final Icon NO_IMAGE = new BlindIcon(15);
    String description;
    String label;
    int state = 0;
    JButton mButton = new JButton();

    public ThreeCheckBoxProperty(String description, String label) {
        this.description = description;
        this.label = label;
        this.mButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThreeCheckBoxProperty.this.setState((ThreeCheckBoxProperty.this.getState() + 1) % 3);
                ThreeCheckBoxProperty.this.firePropertyChangeEvent();
            }
        });
    }

    private int getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setValue(String value) {
        if (value == null || !value.toLowerCase().equals(this.mTrueValue) && !value.toLowerCase().equals(this.mFalseValue) && !value.toLowerCase().equals(this.mDontTouchValue)) {
            throw new IllegalArgumentException("Cannot set a boolean to " + value);
        }
        this.setState(this.transformString(value));
    }

    private int transformString(String string) {
        if (string == null) {
            return 2;
        }
        if (string.toLowerCase().equals(this.mTrueValue)) {
            return 0;
        }
        if (string.toLowerCase().equals(this.mFalseValue)) {
            return 1;
        }
        return 2;
    }

    public String getValue() {
        switch (this.state) {
            case 0: {
                return this.mTrueValue;
            }
            case 1: {
                return this.mFalseValue;
            }
            case 2: {
                return this.mDontTouchValue;
            }
        }
        return null;
    }

    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mButton);
        String tooltiptext = pTranslator.getText(this.getDescription());
        label.setToolTipText(tooltiptext);
        this.mButton.setToolTipText(tooltiptext);
    }

    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }

    protected void setState(int newState) {
        this.state = newState;
        Icon[] icons = new Icon[]{PLUS_IMAGE, MINUS_IMAGE, NO_IMAGE};
        this.mButton.setIcon(icons[this.state]);
    }
}

